package xapi.annotation.model;


import xapi.annotation.model.IsModel;

@SuppressWarnings("all")
public class IsModelBuilder {

  private static final class ImmutableIsModel implements IsModel {

    private final Key key;

    private final Persistent persistence;

    private final Serializable serializable;

    private final String modelType;

    private final String[] propertyOrder;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.IsModel.class;
    }

    public final Key key () {
      return key;
    }

    public final Persistent persistence () {
      return persistence;
    }

    public final Serializable serializable () {
      return serializable;
    }

    public final String modelType () {
      return modelType;
    }

    public final String[] propertyOrder () {
      return propertyOrder;
    }

    private ImmutableIsModel  (Key key, Persistent persistence, Serializable serializable, String modelType, String[] propertyOrder) {
      this.key = key;
      this.persistence = persistence;
      this.serializable = serializable;
      this.modelType = modelType;
      this.propertyOrder = propertyOrder;
    }

  }

  public static IsModelBuilder buildIsModel (String modelType) {
    return new IsModelBuilder(modelType);
  }

  private Key key;

  private Persistent persistence;

  private Serializable serializable;

  private String modelType;

  private String[] propertyOrder;

  public final Key getKey () {
    return key;
  }

  public final IsModelBuilder setKey (Key key) {
    this.key = key;
    return this;
  }

  public final Persistent getPersistence () {
    return persistence;
  }

  public final IsModelBuilder setPersistence (Persistent persistence) {
    this.persistence = persistence;
    return this;
  }

  public final Serializable getSerializable () {
    return serializable;
  }

  public final IsModelBuilder setSerializable (Serializable serializable) {
    this.serializable = serializable;
    return this;
  }

  public final String getModelType () {
    return modelType;
  }

  public final IsModelBuilder setModelType (String modelType) {
    this.modelType = modelType;
    return this;
  }

  public final String[] getPropertyOrder () {
    return propertyOrder;
  }

  public final IsModelBuilder setPropertyOrder (String[] propertyOrder) {
    this.propertyOrder = propertyOrder;
    return this;
  }

  private IsModelBuilder  (String modelType) {
    this.modelType = modelType;
  }

  public IsModel build () {
    return new ImmutableIsModel(key, persistence, serializable, modelType, propertyOrder);
  }

}
