package xapi.annotation.model;

import xapi.annotation.model.Key;

@SuppressWarnings("all")
public class KeyBuilder {

  private static final class ImmutableKey implements Key {

    private final Class<?> keyType;

    private final String value;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.Key.class;
    }

    public final Class<?> keyType () {
      return keyType;
    }

    public final String value () {
      return value;
    }

    private ImmutableKey  (Class<?> keyType, String value) {
      this.keyType = keyType;
      this.value = value;
    }

  }

  public static KeyBuilder buildKey (String value) {
    return new KeyBuilder(value);
  }

  private Class<?> keyType;

  private String value;

  public final Class<?> getKeyType () {
    return keyType;
  }

  public final KeyBuilder setKeyType (Class<?> keyType) {
    this.keyType = keyType;
    return this;
  }

  public final String getValue () {
    return value;
  }

  public final KeyBuilder setValue (String value) {
    this.value = value;
    return this;
  }

  private KeyBuilder  (String value) {
    this.value = value;
  }

  public Key build () {
    return new ImmutableKey(keyType, value);
  }

}
