package xapi.annotation.model;


import xapi.annotation.model.Persistent;

@SuppressWarnings("all")
public class PersistentBuilder {

  private static final class ImmutablePersistent implements Persistent {

    private final boolean patchable;

    private final PersistenceStrategy strategy;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.Persistent.class;
    }

    public final boolean patchable () {
      return patchable;
    }

    public final PersistenceStrategy strategy () {
      return strategy;
    }

    private ImmutablePersistent  (boolean patchable, PersistenceStrategy strategy) {
      this.patchable = patchable;
      this.strategy = strategy;
    }

  }

  public static PersistentBuilder buildPersistent () {
    return new PersistentBuilder();
  }

  private boolean patchable;

  private PersistenceStrategy strategy;

  public final boolean isPatchable () {
    return patchable;
  }

  public final PersistentBuilder setPatchable (boolean patchable) {
    this.patchable = patchable;
    return this;
  }

  public final PersistenceStrategy getStrategy () {
    return strategy;
  }

  public final PersistentBuilder setStrategy (PersistenceStrategy strategy) {
    this.strategy = strategy;
    return this;
  }

  private PersistentBuilder  () {
  }

  public Persistent build () {
    return new ImmutablePersistent(patchable, strategy);
  }

}
