package xapi.annotation.model;

import xapi.annotation.model.QuerierFor;

@SuppressWarnings("all")
public class QuerierForBuilder {

  private static final class ImmutableQuerierFor implements QuerierFor {

    private final String name;

    private final boolean checksNonNull;

    private final boolean checksStringNonEmpty;

    private final String[] checksValidity;

    private final Class<? extends xapi.util.api.MatchesValue<?>>[] validators;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.QuerierFor.class;
    }

    public final String name () {
      return name;
    }

    public final boolean checksNonNull () {
      return checksNonNull;
    }

    public final boolean checksStringNonEmpty () {
      return checksStringNonEmpty;
    }

    public final String[] checksValidity () {
      return checksValidity;
    }

    public final Class<? extends xapi.util.api.MatchesValue<?>>[] validators () {
      return validators;
    }

    private ImmutableQuerierFor  (String name, boolean checksNonNull, boolean checksStringNonEmpty, String[] checksValidity, Class<? extends xapi.util.api.MatchesValue<?>>[] validators) {
      this.name = name;
      this.checksNonNull = checksNonNull;
      this.checksStringNonEmpty = checksStringNonEmpty;
      this.checksValidity = checksValidity;
      this.validators = validators;
    }

  }

  public static QuerierForBuilder buildQuerierFor (String name) {
    return new QuerierForBuilder(name);
  }

  private String name;

  private boolean checksNonNull;

  private boolean checksStringNonEmpty;

  private String[] checksValidity;

  private Class<? extends xapi.util.api.MatchesValue<?>>[] validators;

  public final String getName () {
    return name;
  }

  public final QuerierForBuilder setName (String name) {
    this.name = name;
    return this;
  }

  public final boolean isChecksNonNull () {
    return checksNonNull;
  }

  public final QuerierForBuilder setChecksNonNull (boolean checksNonNull) {
    this.checksNonNull = checksNonNull;
    return this;
  }

  public final boolean isChecksStringNonEmpty () {
    return checksStringNonEmpty;
  }

  public final QuerierForBuilder setChecksStringNonEmpty (boolean checksStringNonEmpty) {
    this.checksStringNonEmpty = checksStringNonEmpty;
    return this;
  }

  public final String[] getChecksValidity () {
    return checksValidity;
  }

  public final QuerierForBuilder setChecksValidity (String[] checksValidity) {
    this.checksValidity = checksValidity;
    return this;
  }

  public final Class<? extends xapi.util.api.MatchesValue<?>>[] getValidators () {
    return validators;
  }

  public final QuerierForBuilder setValidators (Class<? extends xapi.util.api.MatchesValue<?>>[] validators) {
    this.validators = validators;
    return this;
  }

  private QuerierForBuilder  (String name) {
    this.name = name;
  }

  public QuerierFor build () {
    return new ImmutableQuerierFor(name, checksNonNull, checksStringNonEmpty, checksValidity, validators);
  }

}
