package xapi.annotation.model;

import xapi.annotation.model.RemoverFor;

@SuppressWarnings("all")
public class RemoverForBuilder {

  private static final class ImmutableRemoverFor implements RemoverFor {

    private final String value;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.RemoverFor.class;
    }

    public final String value () {
      return value;
    }

    private ImmutableRemoverFor  (String value) {
      this.value = value;
    }

  }

  public static RemoverForBuilder buildRemoverFor (String value) {
    return new RemoverForBuilder(value);
  }

  private String value;

  public final String getValue () {
    return value;
  }

  public final RemoverForBuilder setValue (String value) {
    this.value = value;
    return this;
  }

  private RemoverForBuilder  (String value) {
    this.value = value;
  }

  public RemoverFor build () {
    return new ImmutableRemoverFor(value);
  }

}
