package xapi.annotation.model;


import xapi.annotation.model.Serializable;

@SuppressWarnings("all")
public class SerializableBuilder {

  private static final class ImmutableSerializable implements Serializable {

    private final boolean obfuscated;

    private final ClientToServer clientToServer;

    private final ServerToClient serverToClient;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.Serializable.class;
    }

    public final boolean obfuscated () {
      return obfuscated;
    }

    public final ClientToServer clientToServer () {
      return clientToServer;
    }

    public final ServerToClient serverToClient () {
      return serverToClient;
    }

    private ImmutableSerializable  (boolean obfuscated, ClientToServer clientToServer, ServerToClient serverToClient) {
      this.obfuscated = obfuscated;
      this.clientToServer = clientToServer;
      this.serverToClient = serverToClient;
    }

  }

  public static SerializableBuilder buildSerializable () {
    return new SerializableBuilder();
  }

  private boolean obfuscated;

  private ClientToServer clientToServer;

  private ServerToClient serverToClient;

  public final boolean isObfuscated () {
    return obfuscated;
  }

  public final SerializableBuilder setObfuscated (boolean obfuscated) {
    this.obfuscated = obfuscated;
    return this;
  }

  public final ClientToServer getClientToServer () {
    return clientToServer;
  }

  public final SerializableBuilder setClientToServer (ClientToServer clientToServer) {
    this.clientToServer = clientToServer;
    return this;
  }

  public final ServerToClient getServerToClient () {
    return serverToClient;
  }

  public final SerializableBuilder setServerToClient (ServerToClient serverToClient) {
    this.serverToClient = serverToClient;
    return this;
  }

  private SerializableBuilder  () {
  }

  public Serializable build () {
    return new ImmutableSerializable(obfuscated, clientToServer, serverToClient);
  }

}
