package xapi.annotation.model;


import xapi.annotation.model.ServerToClient;

@SuppressWarnings("all")
public class ServerToClientBuilder {

  private static final class ImmutableServerToClient implements ServerToClient {

    private final SerializationStrategy serializer;

    private final boolean enabled;

    private final boolean encrypted;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.ServerToClient.class;
    }

    public final SerializationStrategy serializer () {
      return serializer;
    }

    public final boolean enabled () {
      return enabled;
    }

    public final boolean encrypted () {
      return encrypted;
    }

    private ImmutableServerToClient  (SerializationStrategy serializer, boolean enabled, boolean encrypted) {
      this.serializer = serializer;
      this.enabled = enabled;
      this.encrypted = encrypted;
    }

  }

  public static ServerToClientBuilder buildServerToClient () {
    return new ServerToClientBuilder();
  }

  private SerializationStrategy serializer;

  private boolean enabled;

  private boolean encrypted;

  public final SerializationStrategy getSerializer () {
    return serializer;
  }

  public final ServerToClientBuilder setSerializer (SerializationStrategy serializer) {
    this.serializer = serializer;
    return this;
  }

  public final boolean isEnabled () {
    return enabled;
  }

  public final ServerToClientBuilder setEnabled (boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  public final boolean isEncrypted () {
    return encrypted;
  }

  public final ServerToClientBuilder setEncrypted (boolean encrypted) {
    this.encrypted = encrypted;
    return this;
  }

  private ServerToClientBuilder  () {
  }

  public ServerToClient build () {
    return new ImmutableServerToClient(serializer, enabled, encrypted);
  }

}
