package xapi.annotation.model;

import xapi.annotation.model.SetterFor;

@SuppressWarnings("all")
public class SetterForBuilder {

  private static final class ImmutableSetterFor implements SetterFor {

    private final String value;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.SetterFor.class;
    }

    public final String value () {
      return value;
    }

    private ImmutableSetterFor  (String value) {
      this.value = value;
    }

  }

  public static SetterForBuilder buildSetterFor () {
    return new SetterForBuilder();
  }

  private String value;

  public final String getValue () {
    return value;
  }

  public final SetterForBuilder setValue (String value) {
    this.value = value;
    return this;
  }

  private SetterForBuilder  () {
  }

  public SetterFor build () {
    return new ImmutableSetterFor(value);
  }

}
