package xapi.annotation.ui;


import xapi.annotation.ui.UiTemplate;

@SuppressWarnings("all")
public class UiTemplateBuilder {

  private static final class ImmutableUiTemplate implements UiTemplate {

    private final UiTemplate.Location location;

    private final UiTemplate.EmbedStrategy embedStrategy;

    private final String id;

    private final String[] keys;

    private final boolean required;

    private final UiTemplate.SourceType type;

    private final String value;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.ui.UiTemplate.class;
    }

    public final UiTemplate.Location location () {
      return location;
    }

    public final UiTemplate.EmbedStrategy embedStrategy () {
      return embedStrategy;
    }

    public final String id () {
      return id;
    }

    public final String[] keys () {
      return keys;
    }

    public final boolean required () {
      return required;
    }

    public final UiTemplate.SourceType type () {
      return type;
    }

    public final String value () {
      return value;
    }

    private ImmutableUiTemplate  (UiTemplate.Location location, UiTemplate.EmbedStrategy embedStrategy, String id, String[] keys, boolean required, UiTemplate.SourceType type, String value) {
      this.location = location;
      this.embedStrategy = embedStrategy;
      this.id = id;
      this.keys = keys;
      this.required = required;
      this.type = type;
      this.value = value;
    }

  }

  public static UiTemplateBuilder buildUiTemplate (String value) {
    return new UiTemplateBuilder(value);
  }

  private UiTemplate.Location location;

  private UiTemplate.EmbedStrategy embedStrategy;

  private String id;

  private String[] keys;

  private boolean required;

  private UiTemplate.SourceType type;

  private String value;

  public final UiTemplate.Location getLocation () {
    return location;
  }

  public final UiTemplateBuilder setLocation (UiTemplate.Location location) {
    this.location = location;
    return this;
  }

  public final UiTemplate.EmbedStrategy getEmbedStrategy () {
    return embedStrategy;
  }

  public final UiTemplateBuilder setEmbedStrategy (UiTemplate.EmbedStrategy embedStrategy) {
    this.embedStrategy = embedStrategy;
    return this;
  }

  public final String getId () {
    return id;
  }

  public final UiTemplateBuilder setId (String id) {
    this.id = id;
    return this;
  }

  public final String[] getKeys () {
    return keys;
  }

  public final UiTemplateBuilder setKeys (String[] keys) {
    this.keys = keys;
    return this;
  }

  public final boolean isRequired () {
    return required;
  }

  public final UiTemplateBuilder setRequired (boolean required) {
    this.required = required;
    return this;
  }

  public final UiTemplate.SourceType getType () {
    return type;
  }

  public final UiTemplateBuilder setType (UiTemplate.SourceType type) {
    this.type = type;
    return this;
  }

  public final String getValue () {
    return value;
  }

  public final UiTemplateBuilder setValue (String value) {
    this.value = value;
    return this;
  }

  private UiTemplateBuilder  (String value) {
    this.value = value;
  }

  public UiTemplate build () {
    return new ImmutableUiTemplate(location, embedStrategy, id, keys, required, type, value);
  }

}
