/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.gwt;

import com.google.gwt.dev.ArgProcessorBase;
import com.google.gwt.util.tools.ArgHandler;
import com.google.gwt.util.tools.ArgHandlerFlag;
import com.google.gwt.util.tools.ArgHandlerInt;
import java.util.Arrays;
import xapi.dev.gwt.CodeServerMain;
import xapi.dev.gwt.i18n.CodeServerDebugMessages;

public class CodeServerGuiOptions {
    private int port = 9876;
    private boolean unload;
    public static final String moduleParam = "module";
    public static final String portParam = "port";
    public static final String unloadParam = "unload";
    public static final String testParam = "testing";

    public String parseArgs(String[] args) {
        return new ArgProcessor(this).processArgs(args) ? null : CodeServerDebugMessages.Debug.unableToStartServer() + Arrays.asList(args);
    }

    public int getPort() {
        return this.port;
    }

    public boolean isUnload() {
        return this.unload;
    }

    public void setUnload(boolean unload) {
        this.unload = unload;
    }

    private class UnloadFlag
    extends ArgHandlerFlag {
        private final CodeServerGuiOptions opts;

        public UnloadFlag(CodeServerGuiOptions opts) {
            this.opts = opts;
        }

        public boolean setFlag(boolean value) {
            this.opts.setUnload(value);
            return value;
        }

        public String getPurposeSnippet() {
            return "When supplied, tell the CodeServerGui to unload the running modules, if any.";
        }

        public String getLabel() {
            return CodeServerGuiOptions.unloadParam;
        }

        public boolean getDefaultValue() {
            return false;
        }
    }

    private class PortFlag
    extends ArgHandlerInt {
        private PortFlag() {
        }

        public String getTag() {
            return "-port";
        }

        public String[] getTagArgs() {
            return new String[]{CodeServerGuiOptions.portParam};
        }

        public String getPurpose() {
            return "The port where the code server will run.";
        }

        public void setInt(int newValue) {
            CodeServerGuiOptions.this.port = newValue;
        }
    }

    private class ArgProcessor
    extends ArgProcessorBase {
        public ArgProcessor(CodeServerGuiOptions opts) {
            this.registerHandler((ArgHandler)new PortFlag());
            this.registerHandler((ArgHandler)new UnloadFlag(opts));
        }

        protected String getName() {
            return CodeServerMain.class.getName();
        }
    }
}

