/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.gwt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import xapi.dev.gwt.CodeServerGuiOptions;
import xapi.dev.gwt.gui.CodeServerGui;
import xapi.dev.gwt.i18n.CodeServerDebugMessages;
import xapi.inject.impl.SingletonProvider;

public class CodeServerMain {
    private static File guiPid;
    private static final SingletonProvider<File> fileProvider;

    public static void main(String[] args) throws Exception {
        Long pid;
        for (String arg : args) {
            System.out.println(arg);
        }
        CodeServerGuiOptions opts = new CodeServerGuiOptions();
        String failure = opts.parseArgs(args);
        if (failure != null) {
            if (failure.length() > 0) {
                System.err.println(CodeServerDebugMessages.Debug.unableToStartServer() + ": " + failure);
            }
            System.exit(1);
        }
        if (null != (pid = CodeServerMain.getRunningGui())) {
            try {
                CodeServerMain.writeOptionsToExistingProcess(pid, opts);
                return;
            }
            catch (Exception arg) {
                // empty catch block
            }
        }
        CodeServerGui server = new CodeServerGui();
        server.run(opts);
        CodeServerMain.trySavePid();
    }

    private static void writeOptionsToExistingProcess(Long pid, CodeServerGuiOptions opts) {
        throw new RuntimeException();
    }

    private static void trySavePid() {
        FileOutputStream out = null;
        try {
            File shared = CodeServerMain.getSharedFile();
            if (null != shared) {
                out = new FileOutputStream(shared);
                out.write(Long.toString(CodeServerMain.getCurrentPid()).getBytes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static File getSharedFile() {
        if (null == guiPid) {
            try {
                guiPid = File.createTempFile("gwt-codeserver-gui", ".x");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return guiPid;
    }

    private static Long getCurrentPid() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            int index = name.indexOf(64);
            Long processId = Long.parseLong(name.substring(0, index));
            return processId;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long getRunningGui() {
        File shared = (File)fileProvider.get();
        if (null != shared) {
            BufferedReader read = null;
            try {
                read = new BufferedReader(new FileReader(shared));
                String first = read.readLine();
                if (null != first) {
                    Long l = Long.parseLong(first);
                    return l;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (read != null) {
                    try {
                        read.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    static {
        fileProvider = new SingletonProvider<File>(){

            protected File initialValue() {
                return CodeServerMain.getSharedFile();
            }
        };
    }
}

