/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.gwt.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CodeServerControls
extends JPanel {
    private transient Runnable launch;
    JTextField module;
    private GridBagLayout layout;
    private final Map<Component, Component> alsoRemove = new HashMap<Component, Component>();
    GridBagConstraints col0 = new GridBagConstraints();
    GridBagConstraints col1 = new GridBagConstraints();

    public CodeServerControls(Runnable launch) {
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.launch = launch;
        this.module = new JTextField("com.example.MyApp");
        this.module.setPreferredSize(new Dimension(350, 30));
        this.module.setSize(new Dimension(350, 30));
        this.render();
    }

    protected void render() {
        this.layout.columnWeights = new double[]{0.3, 0.7};
        this.layout.rowHeights = new int[]{30, 30};
        JButton launcher = new JButton(new AbstractAction("Launch CodeServer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null != CodeServerControls.this.launch) {
                    SwingUtilities.invokeLater(CodeServerControls.this.launch);
                }
            }
        });
        this.add((Component)new JLabel("Target Module"), this.col0);
        this.add((Component)this.module, this.col1);
        this.col0 = new GridBagConstraints();
        this.col1 = new GridBagConstraints();
        this.col0.gridy = 1;
        this.col1.gridy = 1;
        this.add((Component)new JLabel("Start Server"), this.col0);
        this.add((Component)launcher, this.col1);
    }

    @Override
    public Component add(String label, Component comp) {
        ++this.col0.gridy;
        ++this.col1.gridy;
        JLabel jlabel = new JLabel(label);
        this.add((Component)jlabel, this.col0);
        this.add(comp, this.col1);
        this.alsoRemove.put(comp, jlabel);
        return comp;
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        Component alsoRem = this.alsoRemove.remove(comp);
        if (alsoRem != null) {
            super.remove(alsoRem);
        }
    }

    public String getModule() {
        return this.module.getText();
    }

    public void setModule(String module) {
        this.module.setText(module);
        this.module.invalidate();
    }
}

