/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.gwt.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import xapi.collect.impl.AbstractMultiInitMap;
import xapi.dev.gwt.CodeServerGuiOptions;
import xapi.dev.gwt.gui.CodeServerControls;
import xapi.dev.gwt.gui.ProcessLog;
import xapi.dev.gwt.gui.SingleFileSelector;
import xapi.dev.gwt.gui.SourcesSelector;
import xapi.log.X_Log;
import xapi.log.api.LogLevel;
import xapi.util.api.Pair;
import xapi.util.impl.PairBuilder;

public class CodeServerGui
extends JFrame {
    private static File tmpConfig;
    private SingleFileSelector test;
    private SourcesSelector sources;
    private CodeServerControls controls;
    private ProcessLog logger;
    protected final GwtFinder gwtLocations = this.initFinder();
    private final Set<File> classpath = new LinkedHashSet<File>();
    private final Set<File> testClasspath = new LinkedHashSet<File>();

    public CodeServerGui() {
        super("XApi Codeserver");
        BorderLayout layout = new BorderLayout(5, 5);
        this.setLayout(layout);
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 500, 300);
        this.test = new SingleFileSelector("Set Work Directory");
        this.test.setToolTipText("The working directory where gwt codeserver will write compiles.  Defaults to " + tmpConfig.getParent());
        this.test.setChooserType(1);
        this.test.setFile(tmpConfig.getParentFile());
        this.add((Component)this.test, "North");
        this.controls = new CodeServerControls(new Runnable(){

            @Override
            public void run() {
                CodeServerGui.this.launchServer(CodeServerGui.this.isUseTestSources());
            }
        });
        this.add((Component)this.controls, "South");
        this.logger = new ProcessLog(){
            Runnable recalc;

            @Override
            public void invalidate() {
                super.invalidate();
                if (null == this.recalc) {
                    this.recalc = new Runnable(){

                        @Override
                        public void run() {
                            recalc = null;
                            CodeServerGui.this.validate();
                        }
                    };
                    SwingUtilities.invokeLater(this.recalc);
                }
            }
        };
        this.sources = new SourcesSelector("Gwt Sources", this.logger);
        JScrollPane wrap = new JScrollPane(this.logger, 20, 32);
        JSplitPane splitter = new JSplitPane(1);
        splitter.setLeftComponent(this.sources);
        splitter.setRightComponent(wrap);
        splitter.setResizeWeight(0.5);
        this.add((Component)splitter, "Center");
    }

    protected boolean isUseTestSources() {
        return false;
    }

    protected void launchServer(boolean includeTestSources) {
        try {
            String cpSep = File.pathSeparator;
            String cp = this.getClasspath(includeTestSources, cpSep);
            cp = this.alterClasspath(cp, cpSep);
            LinkedList<String> paths = this.getSourcePaths(includeTestSources);
            for (String path : paths.toArray(new String[paths.size()])) {
                File pathFile = new File(path);
                if (!pathFile.exists() || !path.endsWith("classes")) continue;
                cp = cp + cpSep + pathFile;
                paths.remove(path);
            }
            for (File path : this.classpath) {
                if (path.getAbsolutePath().endsWith("classes")) {
                    cp = path + cpSep + cp;
                    continue;
                }
                cp = cp + cpSep + path;
            }
            X_Log.debug((Object[])new Object[]{"Codeserver classpath", cp});
            int debugPort = this.debugPort();
            int len = debugPort > 0 ? 8 : 6;
            String[] cmdArray = new String[len];
            cmdArray[0] = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            cmdArray[1] = "-cp";
            cmdArray[2] = cp.replaceAll("(\\s)", "\\\\$1");
            int pos = 3;
            if (debugPort > 0) {
                cmdArray[pos++] = "-Xdebug";
                cmdArray[pos++] = "-agentlib:jdwp=transport=dt_socket,address=localhost:" + debugPort + ",server=y,suspend=y,timeout=" + this.debugTimeout();
                System.out.println("Waiting to attach debugger on port " + debugPort + " for 10 seconds");
            }
            cmdArray[pos++] = "com.google.gwt.dev.codeserver.CodeServer";
            cmdArray[pos++] = "-port";
            cmdArray[pos++] = Integer.toString(this.getPort());
            String[] srcArray = this.toCli(paths);
            len = 1 + cmdArray.length + srcArray.length;
            final String[] exec = new String[len];
            pos = cmdArray.length;
            System.arraycopy(cmdArray, 0, exec, 0, pos);
            System.arraycopy(srcArray, 0, exec, pos, srcArray.length);
            exec[exec.length - 1] = this.getModule();
            String toRun = Arrays.asList(exec).toString().replaceAll(", ", " ");
            if (X_Log.loggable((LogLevel)LogLevel.TRACE)) {
                X_Log.trace((Object[])new Object[]{"exec:\n", toRun.substring(1, toRun.length() - 1)});
            }
            try {
                Process handle = Runtime.getRuntime().exec(exec);
                if (debugPort > 0) {
                    System.out.println("Not monitoring logs to avoid interfering with debugger");
                } else {
                    this.logger.monitor(handle, this.getModule());
                }
                if (this.getWidth() < 1000) {
                    Rectangle b = this.getBounds();
                    b.width = 1000;
                    b.height = 600;
                    this.setBounds(b);
                }
                final String module = this.getModule();
                final JPanel wrap = new JPanel(new FlowLayout());
                JButton restart = new JButton(new AbstractAction("Kill & Restart"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CodeServerGui.this.logger.stop(module);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Process handle = Runtime.getRuntime().exec(exec);
                                    CodeServerGui.this.logger.monitor(handle, CodeServerGui.this.getModule());
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                    }
                });
                JButton kill = new JButton(new AbstractAction("Kill"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CodeServerGui.this.logger.stop(module);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CodeServerGui.this.controls.remove(wrap);
                                CodeServerGui.this.repaint();
                            }
                        });
                    }
                });
                wrap.add(restart);
                wrap.add(kill);
                this.controls.add(this.getModule(), wrap);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.log("Startup failure", e);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
            this.add((Component)new JLabel(ex.toString()), "West");
        }
    }

    protected int debugTimeout() {
        return 10000;
    }

    protected Pair<String, Boolean> findGwt(String cp, String cpSep) {
        for (String chunk0 : cp.split("[:]")) {
            for (String chunk1 : chunk0.split("[;]")) {
                if ("".equals(chunk1) || !chunk1.contains("gwt-user")) continue;
                try {
                    File jar;
                    File f;
                    int ind = chunk1.lastIndexOf("gwt-user");
                    if (ind < 0 || !(f = new File(chunk1.substring(0, ind))).exists()) continue;
                    X_Log.info((Object[])new Object[]{"Checking for gwt-codeserver from ", f});
                    String version = chunk1.substring(ind + 8).split(".jar")[0];
                    String jarName = "gwt-codeserver";
                    if (!".jar".equals(version) && version.length() > 0) {
                        jarName = jarName + version;
                    }
                    if ((jar = new File(f, jarName = jarName + ".jar")).exists()) {
                        return PairBuilder.pairOf((Object)f.toString(), (Object)false);
                    }
                    File parent = jar.getParentFile();
                    version = version.replace("-", "");
                    if (!parent.getName().equals(version) || !(parent = new File(parent.getParentFile().getParentFile(), "gwt-codeserver")).exists() || !(parent = new File(parent, version)).exists() || !(jar = new File(parent, jarName)).exists()) continue;
                    return PairBuilder.pairOf((Object)parent.getParentFile().getParent(), (Object)true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    protected String alterClasspath(String cp, String cpSep) {
        String gwt = this.gwtLocations.findArtifact(cp, "gwt-codeserver", cpSep);
        gwt = this.gwtLocations.findArtifact(cp, "gwt-dev", cpSep);
        return gwt;
    }

    protected GwtFinder initFinder() {
        return new GwtFinder();
    }

    protected int debugPort() {
        return 0;
    }

    protected int getPort() {
        return 1733;
    }

    protected String[] toCli(LinkedList<String> sourcePaths) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String path : sourcePaths) {
            parts.add("-src");
            parts.add(path);
        }
        return parts.toArray(new String[parts.size()]);
    }

    protected final String getModule() {
        String module = this.controls.getModule();
        if (null == module || module.length() == 0) {
            return this.getModuleDefault();
        }
        return module;
    }

    protected String getModuleDefault() {
        return "wetheinter.net.Demo";
    }

    public void setModule(String module) {
        this.controls.setModule(module);
    }

    protected LinkedList<String> getSourcePaths(boolean includeTestSources) {
        return this.sources.getSourcePaths(includeTestSources);
    }

    protected String getClasspath(boolean includeTestSources, String cpSep) {
        return this.sources.getClasspath(includeTestSources, cpSep);
    }

    public void addSource(File baseDir) {
        this.sources.addSource(baseDir);
    }

    public void addTestSource(File baseDir) {
        this.sources.addTestSource(baseDir);
    }

    public void run(CodeServerGuiOptions opts) {
        if (opts.isUnload()) {
            return;
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void addToClasspath(File f) {
        this.sources.addSource(f);
        this.classpath.add(f);
    }

    public void addToTestClasspath(File f) {
        this.sources.addTestSource(f);
        this.testClasspath.add(f);
    }

    static {
        try {
            tmpConfig = File.createTempFile("xapi-config", "xml");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected class GwtFinder
    extends AbstractMultiInitMap<String, Pair<String, Boolean>, String> {
        public GwtFinder() {
            super(PASS_THRU);
        }

        protected Pair<String, Boolean> initialize(String cp, String sep) {
            return CodeServerGui.this.findGwt(cp, sep);
        }

        public String findArtifact(String cp, String artifact, String cpSep) {
            if (!cp.contains(artifact)) {
                if (cpSep == null) {
                    cpSep = File.separator;
                }
                String version = "";
                if (!cp.contains(artifact)) {
                    X_Log.info((Object[])new Object[]{artifact, " was not found in classpath.  Trying to guess from existing classpath."});
                    try {
                        Pair root = (Pair)this.get(cp, cpSep);
                        File parent = new File((String)root.get0());
                        if (((Boolean)root.get1()).booleanValue()) {
                            // empty if block
                        }
                        String jarName = artifact.split("[.]jar")[0];
                        if (version.length() > 0) {
                            version = version.replace("-", "");
                            jarName = jarName + "-" + version;
                        }
                        jarName = jarName + ".jar";
                        File candidate = new File(parent, jarName);
                        X_Log.trace((Object[])new Object[]{"Checking if ", candidate, " exists"});
                        if (candidate.exists()) {
                            System.out.println("Found " + artifact + " @ " + candidate);
                            cp = cp + cpSep + candidate;
                        } else if (version.length() > 0) {
                            if (parent.getParentFile().getName().equals(version)) {
                                parent = parent.getParentFile();
                            }
                            if (parent.getParentFile().getName().equals("gwt-user")) {
                                parent = parent.getParentFile();
                            }
                            if ((parent = new File(parent, artifact)).exists() && (parent = new File(parent, version)).exists() && (candidate = new File(parent, jarName)).exists()) {
                                System.out.println("Found " + artifact + " @ " + candidate);
                                cp = cp + cpSep + candidate;
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return cp;
        }
    }
}

