/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.gwt.gui;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ProcessLog
extends Box {
    protected static final int LOG_MAX = 0x100000;
    final JTextArea text;
    final JScrollPane scroller;
    StringBuffer body = new StringBuffer();
    HashMap<String, Runnable> onDone = new HashMap();
    WeakHashMap<String, Thread> waitThreads = new WeakHashMap();
    ArrayList<BufferedReader> readerStd = new ArrayList();
    ArrayList<BufferedReader> readerErr = new ArrayList();
    WeakReference<Thread> bufferReader;
    private Runnable redraw;

    public ProcessLog() {
        super(1);
        this.text = new JTextArea(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return false;
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.scroller = new JScrollPane(this.text);
        this.add(this.scroller);
        this.out("Process X_Log");
    }

    public void clear() {
        this.body.setLength(0);
        this.scheduleRedraw();
    }

    public synchronized void monitor(final Process handle, final String module) {
        try {
            int state = handle.exitValue();
            this.out("Process for module " + module + " has already terminated w/ exit code " + state);
            return;
        }
        catch (IllegalThreadStateException e) {
            this.out("Process for module " + module + " is running; engaging logger...");
            final BufferedReader in = new BufferedReader(new InputStreamReader(handle.getInputStream()));
            final BufferedReader err = new BufferedReader(new InputStreamReader(handle.getErrorStream()));
            this.readerStd.add(in);
            this.readerErr.add(err);
            if (this.onDone.containsKey(module)) {
                this.onDone.get(module).run();
            }
            this.onDone.put(module, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProcessLog processLog = ProcessLog.this;
                    synchronized (processLog) {
                        ProcessLog.this.readerStd.remove(in);
                        ProcessLog.this.readerErr.remove(err);
                    }
                    try {
                        handle.destroy();
                    }
                    catch (Exception e) {
                        ProcessLog.this.processStdErr(handle, "Error destroying handle; " + e);
                    }
                }
            });
            if (null == this.bufferReader || null == this.bufferReader.get() || this.bufferReader.isEnqueued()) {
                Runnable bufferRunnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        try {
                            while (ProcessLog.this.isRunning()) {
                                try {
                                    String next;
                                    BufferedReader[] readers;
                                    ProcessLog processLog = ProcessLog.this;
                                    synchronized (processLog) {
                                        readers = ProcessLog.this.readerStd.toArray(new BufferedReader[ProcessLog.this.readerStd.size()]);
                                    }
                                    for (BufferedReader read : readers) {
                                        while (read.ready()) {
                                            while (read.ready()) {
                                                next = read.readLine();
                                                ProcessLog.this.processStdIn(handle, next);
                                            }
                                            Thread.sleep(1L);
                                        }
                                    }
                                    ProcessLog processLog2 = ProcessLog.this;
                                    synchronized (processLog2) {
                                        readers = ProcessLog.this.readerErr.toArray(new BufferedReader[ProcessLog.this.readerErr.size()]);
                                    }
                                    for (BufferedReader read : readers) {
                                        while (read.ready()) {
                                            next = read.readLine();
                                            ProcessLog.this.processStdErr(handle, next);
                                        }
                                    }
                                    Thread.sleep(50L);
                                }
                                catch (IOException e) {
                                    ProcessLog.this.processStdErr(handle, "IOException @ " + Arrays.asList(e.getStackTrace()));
                                    ProcessLog.this.bufferReader = null;
                                    return;
                                }
                                catch (InterruptedException e) {
                                    try {
                                        ProcessLog.this.bufferReader = null;
                                        ProcessLog.this.processStdErr(handle, "Interrupted @ " + Arrays.asList(e.getStackTrace()));
                                        ProcessLog.this.bufferReader = null;
                                        return;
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                        return;
                                    }
                                }
                            }
                        }
                        finally {
                            ProcessLog.this.bufferReader = null;
                        }
                    }
                };
                Thread ioblocker = new Thread(bufferRunnable);
                ioblocker.start();
                this.bufferReader = new WeakReference<Thread>(ioblocker);
            }
            Thread waitThread = new Thread(new Runnable(){
                Thread selfRemove = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ProcessLog.this.out("Destroying module " + module);
                        handle.destroy();
                    }
                });
                {
                    Runtime.getRuntime().addShutdownHook(this.selfRemove);
                }

                @Override
                public void run() {
                    try {
                        int state = handle.exitValue();
                        ProcessLog.this.out("Process for module " + module + " has terminated w/ exit code " + state);
                        return;
                    }
                    catch (IllegalThreadStateException e) {
                        ProcessLog.this.out("Waiting for process " + module + " to finish...");
                        int result = handle.waitFor();
                        ProcessLog.this.out("Process " + module + " finished with exit code " + result);
                        ProcessLog.this.processCompletion(handle, result);
                    }
                    catch (InterruptedException e) {
                        ProcessLog.this.processStdErr(handle, "Interrupted while blocking on monitored command.  \n" + Arrays.asList(e.getStackTrace()));
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        try {
                            if (ProcessLog.this.onDone.containsKey(module)) {
                                ProcessLog.this.onDone.remove(module).run();
                            }
                            if (null != this.selfRemove) {
                                Runtime.getRuntime().removeShutdownHook(this.selfRemove);
                            }
                            this.selfRemove = null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ProcessLog.this.processStdErr(handle, "Error " + e + " while cleaning up process monitor.  \n" + Arrays.asList(e.getStackTrace()));
                        }
                    }
                }
            });
            waitThread.start();
            this.waitThreads.put(module, waitThread);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRunning() {
        ProcessLog processLog = this;
        synchronized (processLog) {
            return this.readerStd.size() > 0 || this.readerErr.size() > 0;
        }
    }

    protected void processCompletion(Process handle, int result) {
    }

    protected void processStdErr(Process handle, String next) {
        this.out("[ERROR] " + next);
    }

    private void out(String string) {
        this.body.append(string + "\n");
        this.scheduleRedraw();
        System.out.println(string);
    }

    public synchronized void stop(String module) {
        if (this.bufferReader != null) {
            Thread thread = (Thread)this.bufferReader.get();
            this.bufferReader.clear();
            if (thread != null) {
                thread.interrupt();
            }
            this.bufferReader = null;
        }
        if (this.waitThreads.containsKey(module)) {
            this.waitThreads.remove(module).interrupt();
        }
        if (this.onDone.containsKey(module)) {
            this.onDone.remove(module).run();
        }
    }

    private void scheduleRedraw() {
        if (this.redraw == null) {
            this.redraw = new Runnable(){
                final Rectangle visibleRect;
                private int lastHeight;
                {
                    this.visibleRect = ProcessLog.this.scroller.getVisibleRect();
                }

                @Override
                public void run() {
                    ProcessLog.this.redraw = null;
                    boolean autoscroll = this.lastHeight == 0 || this.visibleRect.y + ProcessLog.this.scroller.getHeight() == this.lastHeight;
                    int overflow = ProcessLog.this.body.length() - 0x100000;
                    if (overflow > 0) {
                        ProcessLog.this.body.replace(0, overflow, "");
                    }
                    ProcessLog.this.text.setText(ProcessLog.this.body.toString());
                    ProcessLog.this.invalidate();
                    if (autoscroll) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                visibleRect.y = ProcessLog.this.scroller.getHeight() - visibleRect.height + 20;
                                lastHeight = visibleRect.y;
                                ProcessLog.this.scroller.scrollRectToVisible(visibleRect);
                            }
                        });
                    }
                }
            };
            SwingUtilities.invokeLater(this.redraw);
        }
    }

    protected void processStdIn(Process handle, String next) {
        this.out("[INFO] " + next);
    }

    public void log(String string, IOException e) {
        if (string != null && string.length() > 0) {
            this.out(string);
        }
        if (e != null) {
            this.out(e.toString());
            for (StackTraceElement el : e.getStackTrace()) {
                this.out(el.toString());
            }
        }
    }
}

