/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.gwt.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SingleFileSelector
extends JPanel {
    private static final long serialVersionUID = 1213610727860383569L;
    private final JButton button = new JButton("Select File");
    private final JLabel label = new JLabel();
    private final JFileChooser chooser = new JFileChooser();
    private int mode;
    private String buttonText;

    public SingleFileSelector() {
        super(new GridLayout(1, 2, 10, 5));
        this.init();
    }

    public SingleFileSelector(String text) {
        this();
        this.buttonText = text;
        this.button.setText(this.buttonText);
        this.init();
    }

    public void setChooserType(int type) {
        this.chooser.setFileSelectionMode(type);
        this.mode = type;
        if (null == this.buttonText) {
            this.button.setText("Select " + (type == 1 ? "Directory" : (type == 2 ? "File or Directory" : "File")));
        }
    }

    protected void init() {
        if (this.getComponentCount() > 0) {
            return;
        }
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleFileSelector.this.chooser.showOpenDialog(null);
            }
        });
        this.chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = SingleFileSelector.this.chooser.getSelectedFile();
                if (null != file) {
                    switch (SingleFileSelector.this.mode) {
                        case 1: {
                            if (file.isDirectory()) break;
                        }
                    }
                    SingleFileSelector.this.setFile(file);
                }
            }
        });
        this.add(this.button);
        this.add(this.label);
        this.setAlignmentX(0.0f);
    }

    public void setFile(File baseDir) {
        this.label.setText(baseDir.toString());
        this.chooser.setCurrentDirectory(baseDir);
    }
}

