/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.gwt.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import xapi.dev.gwt.gui.ProcessLog;

public class SourcesSelector
extends JPanel {
    private static final long serialVersionUID = 1153019705058563667L;
    private JSplitPane splitter;
    private Label label;
    private DefaultListModel dir;
    private final Set<File> testSources = new LinkedHashSet<File>();
    private JFileChooser chooser;
    private JList list;
    private ProcessLog logger;

    public SourcesSelector(final ProcessLog logger) {
        super(new BorderLayout(0, 5));
        this.logger = logger;
        JPanel buttons = new JPanel(new GridLayout(5, 1, 0, 10));
        buttons.add(new JButton(new AbstractAction("Add Source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourcesSelector.this.chooser.showOpenDialog(null);
            }
        }));
        buttons.add(new JButton(new AbstractAction("Load Sources"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourcesSelector.this.refreshModules();
            }
        }));
        buttons.add(new JButton(new AbstractAction("Remove Source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SourcesSelector.this.list.getSelectedIndices();
                int pos = selected.length;
                while (pos > 0) {
                    SourcesSelector.this.dir.remove(selected[--pos]);
                }
                SourcesSelector.this.refreshModules();
            }
        }));
        buttons.add(new JButton(new AbstractAction("Remove All Sources"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourcesSelector.this.dir.removeAllElements();
                SourcesSelector.this.refreshModules();
            }
        }));
        buttons.add(new JButton(new AbstractAction("Clear Log"){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.clear();
            }
        }));
        this.splitter = new JSplitPane(1);
        this.splitter.setLeftComponent(buttons);
        this.dir = new DefaultListModel();
        this.chooser = new JFileChooser();
        this.chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Directories Or Jars";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.toString().endsWith(".jar");
            }
        });
        this.chooser.setMultiSelectionEnabled(true);
        this.chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (File f : SourcesSelector.this.chooser.getSelectedFiles()) {
                    int ind = SourcesSelector.this.dir.indexOf(f);
                    if (ind > -1) {
                        SourcesSelector.this.dir.remove(ind);
                    }
                    SourcesSelector.this.dir.add(0, f);
                }
                SourcesSelector.this.refreshModules();
            }
        });
        this.list = new JList(this.dir);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                try {
                    File f = (File)value;
                    if (f.isDirectory()) {
                        return super.getListCellRendererComponent((JList<?>)list, f.toString(), index, isSelected, cellHasFocus);
                    }
                    return super.getListCellRendererComponent((JList<?>)list, f.getName(), index, isSelected, cellHasFocus);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selected = SourcesSelector.this.list.getSelectedIndices();
                if (selected.length > 0) {
                    File f = (File)SourcesSelector.this.dir.get(selected[0]);
                    if (f.isDirectory()) {
                        SourcesSelector.this.chooser.setCurrentDirectory(f);
                    } else {
                        SourcesSelector.this.chooser.setCurrentDirectory(f.getParentFile());
                    }
                }
            }
        });
        this.chooser.setFileSelectionMode(2);
        JScrollPane scroller = new JScrollPane(this.list, 20, 31);
        this.splitter.setRightComponent(scroller);
        this.add(this.splitter);
        this.splitter.setDividerLocation(0.5);
    }

    protected void refreshModules() {
    }

    public SourcesSelector(String title, ProcessLog logger) {
        this(logger);
        this.setTitle(title);
    }

    public void setTitle(String title) {
        if (null == this.label) {
            this.label = new Label(title);
            this.label.setAlignment(1);
            this.add((Component)this.label, "North");
        } else {
            this.label.setText(title);
        }
    }

    public void addSource(File file) {
        this.addSource(file, true);
    }

    public void addTestSource(File file) {
        this.addSource(file, true);
        this.testSources.add(file);
    }

    public void addSource(File file, boolean resolve) {
        File next;
        if (resolve && file.isDirectory() && (next = new File(file, "src")).exists() && (next = new File(file = next, "main")).exists() && (next = new File(file = next, "java")).exists()) {
            file = next;
        }
        if (file.isDirectory() || file.toString().endsWith(".jar")) {
            int was = this.dir.indexOf(file);
            if (was > -1) {
                this.dir.remove(was);
            }
            this.dir.add(this.dir.getSize(), file);
        }
    }

    public String getClasspath(boolean includeTestSource, String cpSep) {
        int size = this.dir.getSize();
        StringBuilder b = new StringBuilder();
        String prefix = "";
        int i = -1;
        while (++i < size) {
            File item = (File)this.dir.get(i);
            if (!includeTestSource && this.testSources.contains(item) || !item.isFile()) continue;
            b.append(prefix + item);
            prefix = cpSep;
        }
        return b.toString();
    }

    public LinkedList<String> getSourcePaths(boolean includeTestSource) {
        LinkedList<String> paths = new LinkedList<String>();
        int size = this.dir.getSize();
        int i = -1;
        while (++i < size) {
            File item = (File)this.dir.get(i);
            if (!includeTestSource && this.testSources.contains(item) || !item.isDirectory()) continue;
            paths.add(item.toString());
        }
        return paths;
    }
}

