/*
 * Decompiled with CFR 0.152.
 */
package xapi.mojo.api;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import javax.inject.Provider;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.WorkspaceReader;
import xapi.dev.X_Dev;
import xapi.inject.impl.SingletonProvider;
import xapi.log.X_Log;
import xapi.mojo.gwt.MavenServiceMojo;
import xapi.mvn.X_Maven;
import xapi.time.X_Time;
import xapi.util.X_Debug;
import xapi.util.X_GC;
import xapi.util.X_String;

public abstract class AbstractXapiMojo
extends AbstractMojo {
    @Component
    private ProjectBuilder builder;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private MavenProject project;
    @Component
    private WorkspaceReader workspace;
    @Parameter(property="xapi.gen.dir", defaultValue="target/generated-sources/xapi")
    private String generateDirectory;
    @Parameter(property="xapi.version", defaultValue="0.5-SNAPSHOT")
    private String xapiVersion;
    @Parameter(property="xapi.platform", defaultValue="jre")
    private String platform;
    @Parameter(property="source.root", defaultValue="${project.basedir}")
    private File sourceRoot;
    @Component
    private MavenSession session;
    @Component
    private PluginDescriptor plugin;
    @Parameter(property="target.project", defaultValue="${project.basedir}")
    private String targetProject;
    private final Provider<File> generateDirectoryProvider = new SingletonProvider<File>(){

        protected File initialValue() {
            if (AbstractXapiMojo.this.targetProject == null) {
                return new File(AbstractXapiMojo.this.getSourceRoot(), AbstractXapiMojo.this.generateDirectory);
            }
            X_Log.error((Object[])new Object[]{AbstractXapiMojo.this.targetProjectDirectory.get(), AbstractXapiMojo.this.generateDirectory});
            return new File((File)AbstractXapiMojo.this.targetProjectDirectory.get(), AbstractXapiMojo.this.generateDirectory);
        }
    };
    private final Provider<File> targetProjectDirectory = new SingletonProvider<File>(){

        protected File initialValue() {
            DefaultArtifact artifact;
            Preconditions.checkNotNull((Object)AbstractXapiMojo.this.targetProject, (Object)"You must supply a ${target.project} configuration property in order to use any service methods which depend upon #getTargetPom().");
            boolean endsWithXml = AbstractXapiMojo.this.targetProject.endsWith(".xml");
            File targetFile = new File(AbstractXapiMojo.this.targetProject);
            try {
                targetFile = targetFile.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (endsWithXml && targetFile.exists()) {
                targetFile = targetFile.getParentFile();
            }
            if (targetFile.isDirectory()) {
                return targetFile;
            }
            try {
                targetFile = new File(AbstractXapiMojo.this.sourceRoot.getCanonicalFile(), AbstractXapiMojo.this.targetProject);
                if (targetFile.exists()) {
                    return targetFile.getParentFile();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String[] bits = AbstractXapiMojo.this.targetProject.split(":", -1);
            if (bits.length < 2) {
                throw new AssertionError((Object)("The target.project you supplied, " + AbstractXapiMojo.this.targetProject + ", is neither the " + "location of a pom file (*.xml)," + " nor a maven artifact (groupId:artifactId:extension:version)"));
            }
            if (bits.length == 2) {
                Preconditions.checkArgument((boolean)bits[0].equals("net.wetheinter"), (Object)("Unless your target artifact, " + AbstractXapiMojo.this.targetProject + " begins with group Id, " + "net.wetheinter" + ", you must supply, at the very least, groupId:artifactId:version"));
                artifact = new DefaultArtifact(AbstractXapiMojo.this.targetProject + ":" + "0.5-SNAPSHOT");
            } else {
                artifact = new DefaultArtifact(AbstractXapiMojo.this.targetProject);
            }
            if (AbstractXapiMojo.this.workspace != null) {
                File result = AbstractXapiMojo.this.workspace.findArtifact((Artifact)artifact);
                X_Log.warn((Object[])new Object[]{((Object)((Object)this)).getClass(), "Searching for target project directory from", result, "derived from artifact", artifact, AbstractXapiMojo.this.getSession()});
                if (result != null) {
                    return result.getParentFile().getParentFile();
                }
                MavenProject root = AbstractXapiMojo.this.getSession().getCurrentProject();
                while (root.getParent() != null) {
                    root = root.getParent();
                }
                try {
                    DefaultProjectBuildingRequest req = new DefaultProjectBuildingRequest(AbstractXapiMojo.this.session.getProjectBuildingRequest());
                    req.setProject(root);
                    req.setResolveDependencies(true);
                    ArrayList<File> poms = new ArrayList<File>();
                    poms.add(new File(root.getBasedir(), "pom.xml"));
                    List res = AbstractXapiMojo.this.builder.build(poms, true, (ProjectBuildingRequest)req);
                    for (ProjectBuildingResult proj : res) {
                        String ident = proj.getProject().getArtifact().getId();
                        if (!ident.startsWith(AbstractXapiMojo.this.targetProject) || !ident.equals(AbstractXapiMojo.this.targetProject) && !ident.startsWith(AbstractXapiMojo.this.targetProject + ":")) continue;
                        return proj.getProject().getBasedir();
                    }
                }
                catch (ProjectBuildingException e) {
                    e.printStackTrace();
                }
            }
            throw new RuntimeException("Could not find pom file for " + AbstractXapiMojo.this.targetProject + "; if you wish to target a project outside your " + "maven workspace, you must specify the full location of the project pom" + " (using groupId:artifactId only works if the given project " + "is accessible to WorkspaceReader)");
        }
    };
    public final SingletonProvider<JavaCompiler> compiler = new SingletonProvider<JavaCompiler>(){

        protected JavaCompiler initialValue() {
            return AbstractXapiMojo.this.initCompiler();
        }
    };
    public final SingletonProvider<String[]> compileClasspath = new SingletonProvider<String[]>(){

        protected String[] initialValue() {
            URL[] cp = X_Maven.compileScopeUrls((MavenProject)AbstractXapiMojo.this.getProject(), (MavenSession)AbstractXapiMojo.this.getSession());
            return X_Dev.toStrings((URL[])cp);
        }
    };

    public ProjectBuilder getBuilder() {
        return this.builder;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.plugin;
    }

    public String getPlatform() {
        return this.platform;
    }

    public MavenProject getProject() {
        X_Log.trace((Object[])new Object[]{((Object)((Object)this)).getClass(), "project", this.project, "dependencies", this.project.getDependencies()});
        return this.project;
    }

    public File getGenerateDirectory() {
        return (File)this.generateDirectoryProvider.get();
    }

    public MavenSession getSession() {
        return this.session;
    }

    public File getSourceRoot() {
        return this.sourceRoot;
    }

    public String getXapiVersion() {
        return this.xapiVersion;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenServiceMojo.init(this);
        this.doExecute();
        X_GC.deepDestroy((Class)((Class)Class.class.cast(((Object)((Object)this)).getClass())), (Object)((Object)this));
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public File getTargetProjectDirectory() {
        return (File)this.targetProjectDirectory.get();
    }

    public void compile(String javaName, String source, boolean overwrite, String ... additionalClasspath) {
        File file = this.saveModel(javaName, source, overwrite);
        this.prepareCompile(file, javaName, source, overwrite, additionalClasspath).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveModel(String javaName, String source, boolean overwrite) {
        File genDir = this.getGenerateDirectory();
        X_Log.info((Object[])new Object[]{((Object)((Object)this)).getClass(), "Preparing compile", this.getTargetProjectDirectory(), genDir});
        genDir.mkdirs();
        String sourceName = javaName.endsWith(".java") ? javaName.substring(0, source.length() - 5) : javaName;
        File f = new File(genDir, sourceName.replace('.', File.separatorChar) + ".java");
        try {
            f.getParentFile().mkdirs();
            if (!f.createNewFile()) {
                if (overwrite) {
                    f.delete();
                    f.createNewFile();
                } else {
                    throw new RuntimeException("Source file " + f + " exists, but overwrite was false.");
                }
            }
            FileWriter writer = new FileWriter(f);
            try {
                writer.write(source);
            }
            finally {
                writer.close();
            }
        }
        catch (Exception e) {
            X_Log.error((Object[])new Object[]{"Unable to save generated file", javaName, "to", f, e});
            throw X_Debug.rethrow((Throwable)e);
        }
        return f;
    }

    public Runnable prepareCompile(File srcFile, final String javaName, final String source, boolean overwrite, String ... additionalClasspath) {
        File genDir = this.getGenerateDirectory();
        String[] cp = (String[])this.compileClasspath.get();
        if (additionalClasspath.length > 0) {
            String[] clone = Arrays.copyOf(additionalClasspath, additionalClasspath.length + cp.length);
            System.arraycopy(cp, 0, clone, additionalClasspath.length, cp.length);
            cp = clone;
        }
        final String[] args = new String[]{"-sourcepath", genDir.getAbsolutePath() + File.separator, "-classpath", X_String.join((String)File.pathSeparator, (String[])cp), "-d", this.getProject().getBuild().getDirectory() + File.separator + "classes", "-proc:none", srcFile.getAbsolutePath()};
        X_Log.info((Object[])new Object[]{((Object)((Object)this)).getClass(), "Compile arguments", args});
        return new Runnable(){

            @Override
            public void run() {
                int result;
                try {
                    result = ((JavaCompiler)AbstractXapiMojo.this.compiler.get()).run(null, null, null, args);
                }
                catch (Exception e) {
                    X_Log.error((Object[])new Object[]{"Cannot compile", javaName, ":\n", source, e});
                    throw X_Debug.rethrow((Throwable)e);
                }
                if (result != 0) {
                    throw new RuntimeException("Unable to compile generated source(" + result + ")" + "\nClass: " + javaName + "\nSource: " + source);
                }
            }
        };
    }

    protected JavaCompiler initCompiler() {
        return ToolProvider.getSystemJavaCompiler();
    }

    public String findArtifact(String groupId, String artifactId, String extension, String version) {
        File artifact;
        if (extension == null) {
            extension = "jar";
        }
        if ((artifact = this.workspace.findArtifact((Artifact)new DefaultArtifact(groupId, artifactId, extension, "0.5-SNAPSHOT"))) != null) {
            return artifact.getAbsolutePath();
        }
        return null;
    }

    public String generatedAnnotation() {
        return "@" + Generated.class.getName() + "(" + "\n  value=\"" + ((Object)((Object)this)).getClass().getName() + "\", " + "\n  comments=\"Generated by xapi:annogen\"," + "\n  date=\"" + X_Time.timestamp() + "\"" + ")";
    }

    public String guessVersion(String groupId, String backup) {
        if (this.getPluginDescriptor() != null) {
            for (ComponentDependency dep : this.getPluginDescriptor().getDependencies()) {
                if (!dep.getGroupId().equals(groupId)) continue;
                return dep.getVersion();
            }
        }
        if (this.getProject() != null) {
            for (ComponentDependency dep : this.getProject().getDependencies()) {
                if (!dep.getGroupId().equals(groupId)) continue;
                return dep.getVersion();
            }
        }
        return backup;
    }
}

