/*
 * Decompiled with CFR 0.152.
 */
package xapi.mojo.gwt;

import com.google.gwt.core.shared.GWT;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.resolution.ArtifactResult;
import xapi.dev.gwt.gui.CodeServerGui;
import xapi.inject.impl.SingletonProvider;
import xapi.log.X_Log;
import xapi.mojo.api.AbstractXapiMojo;
import xapi.mvn.X_Maven;
import xapi.util.X_Debug;
import xapi.util.X_Properties;
import xapi.util.X_String;
import xapi.util.api.Pair;
import xapi.util.impl.PairBuilder;

@Mojo(name="codeserver", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class CodeServerMojo
extends AbstractXapiMojo
implements ContextEnabled {
    private static final FileFilter gwt_xml_filter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".gwt.xml");
        }
    };
    @Parameter(property="gwt.module", defaultValue="")
    private String module;
    @Parameter(property="gwt.version")
    private String gwtVersion;
    @Parameter(property="port", defaultValue="1337")
    private Integer port;
    @Parameter(property="debug.port", defaultValue="0")
    private Integer debugPort;
    @Parameter(property="debug.delay", defaultValue="-1")
    private Integer debugDelay;
    @Parameter(property="xapi.include.test", defaultValue="false")
    private Boolean includeTestSource;
    private Log log;
    private Map pluginContext;
    private final SingletonProvider<String> _gwtVersion = new SingletonProvider<String>(){

        protected String initialValue() {
            if (X_String.isNotEmpty((String)CodeServerMojo.this.gwtVersion)) {
                return CodeServerMojo.this.gwtVersion;
            }
            String version = X_Properties.getProperty((String)"gwt.version");
            if (version != null) {
                return version;
            }
            return CodeServerMojo.this.superGuess("com.google.gwt", "2.6.1");
        }
    };
    @Parameter(property="xapi.auto.launch", defaultValue="true")
    private Boolean autoCompile;

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public Map getPluginContext() {
        return this.pluginContext;
    }

    public void setPluginContext(Map pluginContext) {
        this.pluginContext = pluginContext;
    }

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        new CodeServerView().keepAlive();
    }

    protected String superGuess(String groupId, String backup) {
        return super.guessVersion(groupId, backup);
    }

    @Override
    public String guessVersion(String groupId, String backup) {
        String version = X_Properties.getProperty((String)"gwt.version");
        if (version != null) {
            return version;
        }
        version = GWT.getVersion();
        if (version != null) {
            return version;
        }
        return this.superGuess(groupId, backup);
    }

    private class CodeServerView
    extends CodeServerGui {
        private CodeServerView() {
        }

        @Override
        protected int getPort() {
            return CodeServerMojo.this.port == null ? super.getPort() : CodeServerMojo.this.port.intValue();
        }

        @Override
        protected int debugTimeout() {
            return CodeServerMojo.this.debugDelay == null ? -1 : CodeServerMojo.this.debugDelay;
        }

        @Override
        protected int debugPort() {
            int delay = CodeServerMojo.this.debugDelay;
            if (delay < 1) {
                return 0;
            }
            return CodeServerMojo.this.debugPort == 0 ? super.debugPort() : CodeServerMojo.this.debugPort.intValue();
        }

        public void keepAlive() throws MojoExecutionException {
            MavenProject project = CodeServerMojo.this.getProject();
            X_Log.info((Object[])new Object[]{this.getClass(), "Preparing gwt recompiler for " + project, "Include test sources? " + this.isUseTestSources()});
            if (null != project) {
                File f;
                this.addSource(project.getBasedir());
                LinkedList<String> modules = new LinkedList<String>();
                if (this.isUseTestSources()) {
                    for (Object o : project.getTestCompileSourceRoots()) {
                        f = new File(String.valueOf(o));
                        if (f.exists()) {
                            this.addTestSource(f);
                            try {
                                modules.addAll(this.findModules(f));
                            }
                            catch (Exception e) {
                                CodeServerMojo.this.getLog().warn((CharSequence)"An error was encountered while searching for .gwt.xml modules", (Throwable)e);
                            }
                            continue;
                        }
                        X_Log.warn((Object[])new Object[]{this.getClass(), "Test source does not exist", f});
                    }
                    for (Object o : project.getTestResources()) {
                        f = new File(o.getDirectory());
                        if (f.exists()) {
                            this.addTestSource(f);
                            try {
                                modules.addAll(this.findModules(f));
                            }
                            catch (Exception e) {
                                CodeServerMojo.this.getLog().warn((CharSequence)"An error was encountered while searching for .gwt.xml modules", (Throwable)e);
                            }
                            continue;
                        }
                        X_Log.warn((Object[])new Object[]{this.getClass(), "Test resource does not exist", f});
                    }
                }
                for (Object o : project.getCompileSourceRoots()) {
                    f = new File(String.valueOf(o));
                    if (!f.exists()) continue;
                    this.addSource(f);
                    try {
                        modules.addAll(this.findModules(f));
                    }
                    catch (Exception e) {
                        CodeServerMojo.this.getLog().warn((CharSequence)("An error was encountered while searching for .gwt.xml modules in " + f), (Throwable)e);
                    }
                }
                for (Object o : project.getResources()) {
                    f = new File(o.getDirectory());
                    if (!f.exists()) continue;
                    this.addSource(f);
                    try {
                        modules.addAll(this.findModules(f));
                    }
                    catch (Exception e) {
                        CodeServerMojo.this.getLog().warn((CharSequence)("An error was encountered while searching for .gwt.xml modules in " + f), (Throwable)e);
                    }
                }
                if (modules.size() > 0) {
                    this.setModule((String)modules.get(0));
                }
                try {
                    if (this.isUseTestSources()) {
                        for (Object o : project.getTestClasspathElements()) {
                            CodeServerMojo.this.getLog().info((CharSequence)o.toString());
                            f = new File(String.valueOf(o));
                            if (f.exists()) {
                                if (f.isDirectory()) {
                                    this.addToTestClasspath(f);
                                    continue;
                                }
                                this.addTestSource(f);
                                continue;
                            }
                            X_Log.warn((Object[])new Object[]{this.getClass(), "Test classpath element does not exist", f, "from " + o});
                        }
                    }
                    for (Object o : project.getCompileClasspathElements()) {
                        f = new File(String.valueOf(o));
                        if (!f.exists()) continue;
                        if (f.isDirectory()) {
                            this.addToClasspath(f);
                            continue;
                        }
                        this.addSource(f);
                    }
                }
                catch (DependencyResolutionRequiredException e1) {
                    CodeServerMojo.this.getLog().error((CharSequence)"Unable to load compile-scoped classpath elements.\nIf you are extending this plugin, you may need to include &lt;requiresDependencyResolution>compile&lt;/requiresDependencyResolution> in your @Mojo annotation / plugin.xml file", (Throwable)e1);
                }
            }
            this.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String cp = CodeServerView.this.getClasspath(CodeServerMojo.this.includeTestSource, ":");
                    CodeServerView.this.gwtLocations.findArtifact(cp, "gwt-dev", ":");
                    CodeServerView.this.gwtLocations.findArtifact(cp, "gwt-codeserver", ":");
                    int before = cp.length();
                    CodeServerView.this.gwtLocations.findArtifact(cp, "gwt-user", ":");
                    if (before != cp.length()) {
                        // empty if block
                    }
                    if (CodeServerMojo.this.autoCompile.booleanValue()) {
                        CodeServerView.this.launchServer(CodeServerMojo.this.includeTestSource);
                    }
                }
            });
            try {
                while (this.isVisible()) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error while waiting on codeserver", e);
            }
        }

        @Override
        protected boolean isUseTestSources() {
            return Boolean.TRUE.equals(CodeServerMojo.this.includeTestSource);
        }

        @Override
        protected Pair<String, Boolean> findGwt(String cp, String cpSep) {
            VersionRange versions;
            try {
                versions = VersionRange.createFromVersionSpec((String)"[2.5.0,)");
            }
            catch (InvalidVersionSpecificationException e) {
                throw X_Debug.rethrow((Throwable)e);
            }
            DefaultArtifactHandler artifactHandler = new DefaultArtifactHandler("default");
            DefaultArtifact gwtUser = new DefaultArtifact("com.google.gwt", "gwt-user", versions, "compile", "default", "jar", (ArtifactHandler)artifactHandler);
            Artifact local = CodeServerMojo.this.getSession().getLocalRepository().find((Artifact)gwtUser);
            if (local != null) {
                return PairBuilder.pairOf((Object)local.getFile().getParentFile().getParent(), (Object)true);
            }
            return super.findGwt(cp, cpSep);
        }

        @Override
        protected String getModuleDefault() {
            if (!"".equals(CodeServerMojo.this.module)) {
                return CodeServerMojo.this.module;
            }
            for (String source : CodeServerMojo.this.getProject().getCompileSourceRoots()) {
                File f = new File(source);
                if (!f.exists()) continue;
                try {
                    String module = this.findModule(f);
                    if (module == null) continue;
                    return module;
                }
                catch (Throwable e) {
                    X_Log.error((Object[])new Object[]{"Failed lookup of gwt module for ", f, e});
                }
            }
            return super.getModuleDefault();
        }

        protected Collection<String> findModules(File f) throws FileNotFoundException, XmlPullParserException, IOException {
            ArrayList<String> list = new ArrayList<String>();
            this.findModules(f, list);
            return list;
        }

        private void findModules(File f, Collection<String> into) throws FileNotFoundException, XmlPullParserException, IOException {
            block3: {
                block2: {
                    if (!f.isDirectory()) break block2;
                    for (File child : f.listFiles(gwt_xml_filter)) {
                        this.findModules(child, into);
                    }
                    break block3;
                }
                if (!f.getName().endsWith(".gwt.xml")) break block3;
                CodeServerMojo.this.getLog().debug((CharSequence)("Checking for entry points in " + f));
                Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new FileReader(f));
                CodeServerMojo.this.getLog().debug((CharSequence)dom.toString());
                for (Xpp3Dom entry : dom.getChildren("entry-point")) {
                    String attr = entry.getAttribute("class");
                    if (null == attr || attr.length() <= 0) continue;
                    into.add(attr.substring(0, attr.lastIndexOf(46, attr.lastIndexOf(46) - 1)) + "." + f.getName().replace(".gwt.xml", ""));
                }
            }
        }

        private String findModule(File f) throws FileNotFoundException, XmlPullParserException, IOException {
            block3: {
                block2: {
                    if (!f.isDirectory()) break block2;
                    for (File child : f.listFiles(gwt_xml_filter)) {
                        String module = this.findModule(child);
                        if (module == null) continue;
                        return module;
                    }
                    break block3;
                }
                if (!f.getName().endsWith(".gwt.xml")) break block3;
                CodeServerMojo.this.getLog().debug((CharSequence)("Checking for entry points in " + f));
                Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new FileReader(f));
                CodeServerMojo.this.getLog().debug((CharSequence)dom.toString());
                for (Xpp3Dom entry : dom.getChildren("entry-point")) {
                    String attr = entry.getAttribute("class");
                    if (null == attr || attr.length() <= 0) continue;
                    return attr.substring(0, attr.lastIndexOf(46, attr.lastIndexOf(46) - 1)) + "." + f.getName().replace(".gwt.xml", "");
                }
            }
            return null;
        }

        @Override
        protected CodeServerGui.GwtFinder initFinder() {
            return new CodeServerGui.GwtFinder(){

                @Override
                public String findArtifact(String cp, String artifact, String cpSep) {
                    if (cp.contains(artifact)) {
                        return cp;
                    }
                    String location = CodeServerView.this.locateArtifact(cp, artifact, cpSep);
                    File f = new File(location);
                    if (f.exists()) {
                        CodeServerView.this.addToClasspath(f);
                        return f.getAbsolutePath() + cpSep + cp;
                    }
                    X_Log.warn((Object[])new Object[]{"Could not find artifact", artifact, "looked in", f});
                    return super.findArtifact(cp, artifact, cpSep);
                }
            };
        }

        protected String locateArtifact(String cp, String artifact, String cpSep) {
            ArtifactResult location = X_Maven.loadArtifact((String)"com.google.gwt", (String)artifact, (String)CodeServerMojo.this.guessVersion("com.google.gwt", "2.6.1"));
            if (location.isResolved()) {
                return location.getArtifact().getFile().getAbsolutePath();
            }
            return null;
        }
    }
}

