/*
 * Decompiled with CFR 0.152.
 */
package xapi.mojo.model;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import xapi.annotation.reflect.MirroredAnnotation;
import xapi.bytecode.ClassFile;
import xapi.bytecode.impl.BytecodeAdapterService;
import xapi.dev.scanner.impl.ClasspathResourceMap;
import xapi.dev.source.ClassBuffer;
import xapi.dev.source.FieldBuffer;
import xapi.dev.source.MethodBuffer;
import xapi.dev.source.SourceBuilder;
import xapi.log.X_Log;
import xapi.mojo.api.AbstractXapiMojo;
import xapi.mvn.X_Maven;
import xapi.source.api.IsAnnotation;
import xapi.source.api.IsAnnotationValue;
import xapi.source.api.IsClass;
import xapi.source.api.IsMethod;
import xapi.source.api.IsType;
import xapi.source.api.Primitives;
import xapi.util.X_Debug;

@Mojo(name="annogen", aggregator=true, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class AnnotationGeneratorMojo
extends AbstractXapiMojo {
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        ClasspathResourceMap scanner = X_Maven.compileScopeScanner((MavenProject)this.getProject(), (MavenSession)this.getSession());
        BytecodeAdapterService adapter = X_Maven.compileScopeAdapter((MavenProject)this.getProject(), (MavenSession)this.getSession());
        HashMap<String, SourceBuilder<IsClass>> generated = new HashMap<String, SourceBuilder<IsClass>>();
        X_Log.trace((Object[])new Object[]{((Object)((Object)this)).getClass(), "Scanning compile scope dependencies", scanner});
        for (ClassFile mirror : scanner.findClassAnnotatedWith(new Class[]{MirroredAnnotation.class})) {
            X_Log.trace((Object[])new Object[]{((Object)((Object)this)).getClass(), "Adding annotation type", mirror});
            this.addType(mirror.getName(), mirror.getPackage(), generated, adapter);
        }
        String[] cp = this.getAdditionalClasspath();
        X_Log.trace((Object[])new Object[]{((Object)((Object)this)).getClass(), "Compiling generated annotations with classpath", cp});
        ArrayList compileTasks = new ArrayList();
        for (Object type : generated.keySet()) {
            SourceBuilder builder = (SourceBuilder)generated.get(type);
            IsClass cls = (IsClass)builder.getPayload();
            String clsName = cls.getSimpleName().replace("[]", "");
            ClassBuffer out = builder.getClassBuffer();
            MethodBuffer factory = (MethodBuffer)((MethodBuffer)out.createMethod("public static " + clsName + " build()").addParameters(new String[]{IsAnnotation.class.getName() + " from"}).println(IsAnnotationValue.class.getSimpleName() + " __value;")).println(clsName + "Proxy proxy = new " + clsName + "Proxy(from);");
            MethodBuffer ctor = out.createMethod("private " + clsName + "Proxy()").addParameters(new String[]{IsAnnotation.class.getName() + " from"});
            boolean firstDefault = true;
            for (IsMethod method : cls.getMethods()) {
                if (method.getEnclosingType().getQualifiedName().equals("java.lang.Object")) continue;
                if (method.getName().equals("type")) {
                    X_Log.error((Object[])new Object[]{"\n\n\n\n\n", method.getReturnType().toString(), "   ", method.getQualifiedName()});
                }
                String returnType = out.addImport(method.getReturnType().toString());
                IsClass returnClass = adapter.toClass(method.getReturnType().getQualifiedName().replace("[]", ""));
                if (method.getName().equals("annotationType")) continue;
                ((FieldBuffer)out.createField(returnType, method.getName()).setExactName(true).setModifier(2)).addGetter(17);
                IsAnnotationValue value = method.getDefaultValue();
                if (value != null) {
                    if (firstDefault) {
                        ctor.println(IsAnnotationValue.class.getSimpleName() + " __value;");
                        firstDefault = false;
                    }
                    ctor.println("__value = from.getDefaultValue(from.getMethod(\"" + method.getName() + "\"));");
                    if (method.getReturnType().getSimpleName().contains("[]")) {
                        // empty if block
                    }
                    ctor.println("this." + method.getName() + " = " + this.getExtractor(out, returnClass, method, returnType) + ";");
                }
                factory.println("__value = from.getValue(from.getMethod(\"" + method.getName() + "\"));");
                factory.println("proxy." + method.getName() + " = " + this.getExtractor(out, returnClass, method, returnType) + ";");
            }
            factory.returnValue("proxy");
            String javaName = cls.getQualifiedName().replace("[]", "") + "Proxy";
            String source = builder.toString();
            File file = this.saveModel(javaName, source, true);
        }
        ArrayList<Thread> runningTasks = new ArrayList<Thread>();
        for (Runnable task : compileTasks) {
            Thread t = new Thread(task);
            t.setDaemon(true);
            t.start();
            runningTasks.add(t);
        }
        long deadline = System.currentTimeMillis() + 10000L;
        while (!runningTasks.isEmpty()) {
            Iterator iter = runningTasks.iterator();
            while (iter.hasNext()) {
                if (((Thread)iter.next()).isAlive()) continue;
                iter.remove();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw X_Debug.rethrow((Throwable)e);
            }
            if (System.currentTimeMillis() <= deadline) continue;
            throw new MojoExecutionException("Failed to compile annotation in 10 seconds.");
        }
    }

    private String getExtractor(ClassBuffer out, IsClass returnClass, IsMethod method, String returnType) {
        if (returnClass.isAnnotation()) {
            String proxyType = out.addImport(returnClass.getQualifiedName() + "Proxy");
            return proxyType + ".build((IsAnnotation)__value.getRawValue())";
        }
        if (returnClass instanceof Primitives) {
            Primitives primitive = (Primitives)returnClass;
            return "(" + primitive.getObjectName() + ")__value.getRawValue()";
        }
        return "(" + returnType + ")__value.getRawValue()";
    }

    private String[] getAdditionalClasspath() {
        return new String[]{this.findArtifact("net.wetheinter", "xapi-dev-bytecode", "jar", "0.5-SNAPSHOT"), this.findArtifact("net.wetheinter", "xapi-core-reflect", "jar", "0.5-SNAPSHOT")};
    }

    private void addType(String annoName, String annoPackage, Map<String, SourceBuilder<IsClass>> generated, BytecodeAdapterService adapter) {
        SourceBuilder generator = generated.get(annoName);
        if (generator == null) {
            IsClass anno = adapter.toClass(annoName);
            generator = new SourceBuilder("public final class " + anno.getSimpleName() + "Proxy");
            ((ClassBuffer)((ClassBuffer)generator.setPackage(annoPackage).setPayload((Object)anno).getClassBuffer().addInterface(annoName).addImports(new Class[]{Annotation.class, IsAnnotation.class, IsAnnotationValue.class})).addAnnotation("@SuppressWarnings(\"all\")")).addAnnotation(this.generatedAnnotation());
            String clsName = generator.getImports().addImport(anno.getQualifiedName());
            generated.put(annoName, (SourceBuilder<IsClass>)generator);
            for (IsMethod method : anno.getMethods()) {
                IsType ret;
                IsClass retClass;
                if (method.getEnclosingType().getQualifiedName().equals("java.lang.Object")) continue;
                if (method.getName().equals("annotationType")) {
                    ((MethodBuffer)generator.getClassBuffer().createMethod("public Class<? extends Annotation> annotationType()").setModifier(17)).returnValue(clsName + ".class");
                }
                if (!(retClass = adapter.toClass((ret = method.getReturnType()).getQualifiedName())).isAnnotation()) continue;
                this.addType(retClass.getQualifiedName().replace("[]", ""), retClass.getPackage(), generated, adapter);
            }
        }
    }
}

