/*
 * Decompiled with CFR 0.152.
 */
package xapi.mojo.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import xapi.annotation.model.IsModel;
import xapi.bytecode.ClassFile;
import xapi.bytecode.impl.BytecodeAdapterService;
import xapi.dev.model.HasModelFields;
import xapi.dev.model.ModelField;
import xapi.dev.scanner.X_Scanner;
import xapi.dev.scanner.impl.ClasspathResourceMap;
import xapi.inject.impl.SingletonProvider;
import xapi.log.X_Log;
import xapi.model.api.Model;
import xapi.mojo.api.AbstractXapiMojo;
import xapi.mvn.X_Maven;
import xapi.source.X_Source;
import xapi.source.api.HasQualifiedName;
import xapi.source.api.IsAnnotation;
import xapi.source.api.IsClass;
import xapi.source.api.IsMethod;
import xapi.util.X_Debug;
import xapi.util.api.ConvertsValue;

@Mojo(name="modelgen", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ModelGeneratorMojo
extends AbstractXapiMojo {
    private final SingletonProvider<ConvertsValue<IsAnnotation, IsModel>> builder = new SingletonProvider<ConvertsValue<IsAnnotation, IsModel>>(){

        protected ConvertsValue<IsAnnotation, IsModel> initialValue() {
            return new ConvertsValue<IsAnnotation, IsModel>(){
                Method cls;

                public IsModel convert(IsAnnotation from) {
                    try {
                        if (this.cls == null) {
                            this.cls = Class.forName(IsModel.class.getName() + "Proxy", true, Thread.currentThread().getContextClassLoader()).getDeclaredMethod("build", IsAnnotation.class);
                        }
                        return (IsModel)this.cls.invoke(null, from);
                    }
                    catch (Throwable e) {
                        throw X_Debug.rethrow((Throwable)e);
                    }
                }
            };
        }
    };

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        MavenProject project = this.getSession().getCurrentProject();
        Build build = project.getBuild();
        ClasspathResourceMap classFolder = X_Scanner.scanFolder((String)build.getOutputDirectory(), (boolean)true, (boolean)false, (boolean)false, (String)"");
        ClasspathResourceMap environment = X_Maven.compileScopeScanner((MavenProject)project, (MavenSession)this.getSession());
        BytecodeAdapterService adapter = X_Maven.compileScopeAdapter((MavenProject)project, (MavenSession)this.getSession());
        IdentityHashMap<ClassFile, Integer> models = new IdentityHashMap<ClassFile, Integer>();
        for (ClassFile model : classFolder.findImplementationOf(new Class[]{Model.class})) {
            models.put(model, 1);
        }
        for (ClassFile model : classFolder.findClassAnnotatedWith(new Class[]{IsModel.class})) {
            if (models.containsKey(model)) continue;
            models.put(model, 0);
        }
        Iterator i = models.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (((Integer)entry.getValue()).equals(0)) {
                this.buildPojo((ClassFile)entry.getKey(), adapter, environment);
            } else {
                this.buildModel((ClassFile)entry.getKey(), adapter, environment);
            }
            i.remove();
        }
    }

    void buildModel(ClassFile clsFile, BytecodeAdapterService adapter, ClasspathResourceMap classpath) {
        X_Log.info((Object[])new Object[]{"Building model ", clsFile});
        IsClass cls = adapter.toClass(clsFile.getName());
        IsAnnotation modelAnno = cls.getAnnotation(IsModel.class.getName());
        HasModelFields model = new HasModelFields();
        if (modelAnno != null) {
            IsModel isModel = (IsModel)((ConvertsValue)this.builder.get()).convert((Object)modelAnno);
            model.setDefaultSerializable(isModel.serializable());
            model.setDefaultPersistence(isModel.persistence());
            model.setKey(isModel.key());
        }
        this.collectModelFields(model, cls, adapter);
    }

    private void collectModelFields(HasModelFields model, IsClass cls, BytecodeAdapterService adapter) {
        if (cls.isInterface()) {
            for (IsMethod method : cls.getMethods()) {
                if (X_Source.isJavaLangObject((HasQualifiedName)method.getEnclosingType()) || HasModelFields.isModel((HasQualifiedName)method.getEnclosingType())) continue;
                ModelField field = model.getOrMakeField(this.normalizeName(method.getName()));
                X_Log.info((Object[])new Object[]{"Field", field});
                boolean unknownType = true;
                for (IsAnnotation anno : method.getAnnotations()) {
                    X_Log.info((Object[])new Object[]{"Anno", anno});
                }
                if (!unknownType) continue;
                Annotation annotation = this.guessType(method);
            }
            for (IsMethod method : cls.getInterfaces()) {
            }
        } else {
            for (IsMethod method : cls.getMethods()) {
                if (!method.isAbstract()) continue;
            }
        }
    }

    private Annotation guessType(IsMethod method) {
        if (method.getParameters().length != 0 || method.getName().startsWith("rem") || method.getName().startsWith("clear")) {
            // empty if block
        }
        return null;
    }

    private String normalizeName(String name) {
        X_Log.info((Object[])new Object[]{"Method w/ name", name});
        return name;
    }

    private void buildPojo(ClassFile key, BytecodeAdapterService adapter, ClasspathResourceMap classpath) {
        X_Log.info((Object[])new Object[]{"Building pojo ", key});
    }
}

