/*
 * Decompiled with CFR 0.152.
 */
package wetheinter.net.dev.io;

import java.util.Set;
import java.util.TreeSet;
import wetheinter.net.dev.io.JavaMetadata;
import wetheinter.net.dev.io.MethodBuffer;
import wetheinter.net.dev.io.PrintBuffer;
import wetheinter.net.dev.io.SourceBuilder;
import wetheinter.net.dev.template.CompilationFailed;

public class ClassBuffer
extends PrintBuffer {
    protected int privacy;
    private boolean isClass;
    private boolean isStatic;
    private boolean isFinal;
    private boolean isAbstract;
    private String superClass;
    private String simpleName;
    private final Set<String> interfaces;
    private final Set<String> generics;
    private SourceBuilder<?> context;
    private boolean isWellFormatted;
    private PrintBuffer prefix;

    public ClassBuffer() {
        this(new SourceBuilder());
    }

    public ClassBuffer(SourceBuilder<?> context) {
        this.context = context;
        this.interfaces = new TreeSet<String>();
        this.generics = new TreeSet<String>();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(10);
        b.append(this.indent);
        if (this.prefix != null) {
            b.append(this.prefix);
        }
        if (this.privacy == 1) {
            b.append("public ");
        } else if (this.privacy == 2) {
            b.append("private ");
        } else if (this.privacy == 4) {
            b.append("protected ");
        }
        if (this.isStatic) {
            b.append("static ");
        }
        if (this.isAbstract) {
            b.append("abstract ");
        }
        if (this.isFinal) {
            b.append("final ");
        }
        if (this.isClass) {
            b.append("class ");
        } else {
            b.append("interface ");
        }
        b.append(this.simpleName + " ");
        if (this.isClass) {
            if (this.superClass != null) {
                b.append("extends " + this.superClass);
            }
            if (this.interfaces.size() > 0) {
                b.append("implements ");
                for (String iface : this.interfaces) {
                    b.append(iface);
                    b.append(", ");
                }
                b.delete(b.length() - 3, b.length() - 1);
            }
        } else if (this.interfaces.size() > 0) {
            b.append("extends ");
            for (String iface : this.interfaces) {
                b.append(iface);
                b.append(", ");
            }
            b.delete(b.length() - 2, b.length());
        }
        if (this.generics.size() > 0) {
            b.append("<");
            for (String generic : this.generics) {
                b.append(generic);
                b.append(", ");
            }
            b.delete(b.length() - 2, b.length());
            b.append("> ");
        }
        b.append("{");
        b.append('\n');
        return b + super.toString();
    }

    @Override
    public PrintBuffer addToBeginning(PrintBuffer buffer) {
        if (this.prefix == null) {
            this.prefix = new PrintBuffer();
        }
        this.prefix.addToBeginning(buffer);
        return this;
    }

    public ClassBuffer setDefinition(String definition, boolean wellFormatted) {
        JavaMetadata metadata = new JavaMetadata(definition);
        this.isWellFormatted = wellFormatted;
        this.privacy = metadata.getPrivacy();
        this.isStatic = metadata.isStatic();
        this.isFinal = metadata.isFinal();
        this.isAbstract = metadata.isAbstract();
        this.isClass = metadata.isClass();
        this.addInterfaces(metadata.getInterfaces());
        this.superClass = metadata.getSuperClass();
        definition = metadata.getClassName();
        this.context.getImports().addImports(metadata.getImports());
        if (metadata.hasGenerics()) {
            String[] generic;
            this.generics.clear();
            for (String s : generic = metadata.getGenerics()) {
                this.generics.add(s);
            }
        }
        if (definition.contains(" ")) {
            throw new CompilationFailed("Found ambiguous class definition in " + definition);
        }
        if (definition.length() == 0) {
            throw new CompilationFailed("Did not have a class name in class definition " + definition);
        }
        this.simpleName = definition;
        return this;
    }

    public void addInterfaces(String ... interfaces) {
        for (String superInterface : interfaces) {
            int index = (superInterface = superInterface.trim()).lastIndexOf(".");
            if (index > 0) {
                this.context.getImports().addImport(superInterface);
                this.interfaces.add(superInterface.substring(index + 1));
                continue;
            }
            this.interfaces.add(superInterface);
        }
    }

    public ClassBuffer addGenerics(String ... generics) {
        for (String generic : generics) {
            boolean noImport = (generic = generic.trim()).contains("!");
            if (noImport) {
                this.generics.add(generic.replace("!", ""));
                continue;
            }
            for (String part : generic.split(" ")) {
                int index = part.lastIndexOf(".");
                if (index <= 0) continue;
                this.context.getImports().addImport(part);
                generic = generic.replace(part.substring(0, index + 1), "");
            }
            this.generics.add(generic);
        }
        return this;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String className) {
        this.simpleName = className;
    }

    public ClassBuffer createInnerClass(String classDef) {
        ClassBuffer inner = new ClassBuffer(this.context);
        inner.indent = this.indent + "  ";
        inner.setDefinition(classDef, classDef.trim().endsWith("{"));
        this.addToEnd(inner);
        return inner;
    }

    public MethodBuffer createMethod(String methodDef) {
        MethodBuffer method = new MethodBuffer(this.context);
        method.indent = this.indent + "  ";
        method.setDefinition(methodDef);
        this.addToEnd(method);
        return method;
    }

    @Override
    protected String footer() {
        return this.isWellFormatted ? "" : "\n" + this.indent + "}\n";
    }

    @Override
    public ClassBuffer append(boolean b) {
        super.append(b);
        return this;
    }

    @Override
    public ClassBuffer append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public ClassBuffer append(char[] str) {
        super.append(str);
        return this;
    }

    @Override
    public ClassBuffer append(char[] str, int offset, int len) {
        super.append(str, offset, len);
        return this;
    }

    @Override
    public ClassBuffer append(CharSequence s) {
        super.append(s);
        return this;
    }

    @Override
    public ClassBuffer append(CharSequence s, int start, int end) {
        super.append(s, start, end);
        return this;
    }

    @Override
    public ClassBuffer append(double d) {
        super.append(d);
        return this;
    }

    @Override
    public ClassBuffer append(float f) {
        super.append(f);
        return this;
    }

    @Override
    public ClassBuffer append(int i) {
        super.append(i);
        return this;
    }

    @Override
    public ClassBuffer append(long lng) {
        super.append(lng);
        return this;
    }

    @Override
    public ClassBuffer append(Object obj) {
        super.append(obj);
        return this;
    }

    @Override
    public ClassBuffer append(String str) {
        super.append(str);
        return this;
    }

    @Override
    public ClassBuffer indent() {
        super.indent();
        return this;
    }

    @Override
    public ClassBuffer indentln(char[] str) {
        super.indentln(str);
        return this;
    }

    @Override
    public ClassBuffer indentln(CharSequence s) {
        super.indentln(s);
        return this;
    }

    @Override
    public ClassBuffer indentln(Object obj) {
        super.indentln(obj);
        return this;
    }

    @Override
    public ClassBuffer indentln(String str) {
        super.indentln(str);
        return this;
    }

    @Override
    public ClassBuffer outdent() {
        super.outdent();
        return this;
    }

    @Override
    public ClassBuffer println() {
        super.println();
        return this;
    }

    @Override
    public ClassBuffer println(char[] str) {
        super.println(str);
        return this;
    }

    @Override
    public ClassBuffer println(CharSequence s) {
        super.println(s);
        return this;
    }

    @Override
    public ClassBuffer println(Object obj) {
        super.println(obj);
        return this;
    }

    @Override
    public ClassBuffer println(String str) {
        super.println(str);
        return this;
    }
}

