/*
 * Decompiled with CFR 0.152.
 */
package wetheinter.net.dev.io;

import java.util.TreeSet;

public class ImportSection {
    private TreeSet<String> imports = new TreeSet();
    private TreeSet<String> importStatic = new TreeSet();

    public void addImports(String ... imports) {
        for (String iport : imports) {
            this.addImport(iport);
        }
    }

    public void addImport(String importName) {
        if (importName.startsWith("import ")) {
            this.imports.add(importName.trim());
        } else {
            this.imports.add("import " + importName + ";");
        }
    }

    public void addStatics(String ... imports) {
        for (String iport : imports) {
            this.addStatic(iport);
        }
    }

    public void addStatic(String importName) {
        if (importName.startsWith("import static ")) {
            this.importStatic.add(importName.trim());
        } else {
            this.importStatic.add("import static " + importName + ";");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(10);
        for (String importName : this.imports) {
            b.append(importName);
            b.append('\n');
        }
        for (String importName : this.importStatic) {
            b.append(importName);
            b.append('\n');
        }
        return b.toString() + '\n';
    }
}

