/*
 * Decompiled with CFR 0.152.
 */
package wetheinter.net.dev.io;

import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;
import wetheinter.net.dev.template.CompilationFailed;

public class JavaMetadata {
    private final int modifier;
    private final boolean isClass;
    private final boolean isGenerics;
    private final Set<String> interfaces = new TreeSet<String>();
    private final Set<String> generics = new TreeSet<String>();
    private final Set<String> imports = new TreeSet<String>();
    private final String superClass;
    private final String className;

    public JavaMetadata(String definition) {
        int index;
        String original = definition;
        int modifier = 0;
        if (definition.contains("public ")) {
            definition = definition.replace("public ", "");
            modifier = 1;
        } else if (definition.contains("protected ")) {
            definition = definition.replace("protected ", "");
            modifier = 4;
        } else if (definition.contains("private ")) {
            definition = definition.replace("private ", "");
            modifier = 2;
        } else {
            modifier = 0;
        }
        definition = definition.replace("{", "");
        if (definition.contains("static ")) {
            modifier |= 8;
            definition = definition.replace("static ", "");
        }
        if (definition.contains("final ")) {
            modifier |= 0x10;
            definition = definition.replace("final ", "");
        }
        if (definition.contains("native ")) {
            modifier |= 0x100;
            definition = definition.replace("native ", "");
        }
        if (definition.contains("synchronized ")) {
            modifier |= 0x20;
            definition = definition.replace("synchronized ", "");
        }
        if (definition.contains("abstract ")) {
            if (Modifier.isFinal(modifier |= 0x400)) {
                throw new CompilationFailed("A class or method cannot be both abstract and final!");
            }
            if (Modifier.isNative(modifier)) {
                throw new CompilationFailed("A method cannot be both abstract and native!");
            }
            definition = definition.replace("abstract ", "");
        }
        this.modifier = modifier;
        if (definition.contains("interface ")) {
            definition = definition.replace("interface ", "");
            this.isClass = false;
            this.superClass = null;
            index = definition.indexOf("extends ");
            if (index > 0) {
                for (String iface : definition.substring(index + 8).split(",")) {
                    index = (iface = iface.trim()).lastIndexOf(46);
                    if (index > 0) {
                        this.imports.add(iface);
                        iface = iface.substring(index + 1);
                    }
                    this.interfaces.add(iface);
                }
                definition = definition.substring(0, index);
            }
        } else {
            this.isClass = definition.contains("class");
            if (this.isClass) {
                index = (definition = definition.replace("class ", "")).indexOf("extends ");
                if (index > 0) {
                    int endIndex = definition.indexOf(32, index + 9);
                    this.superClass = definition.substring(index + 8, endIndex);
                    definition = definition.replace(this.superClass + " ", "");
                } else {
                    this.superClass = null;
                }
                index = definition.indexOf("implements ");
                if (index > 0) {
                    for (String iface : definition.substring(index + 11).split(",")) {
                        index = (iface = iface.trim()).lastIndexOf(46);
                        if (index > 0) {
                            this.imports.add(iface);
                            iface = iface.substring(index + 1);
                        }
                        this.interfaces.add(iface);
                    }
                    definition = definition.substring(0, index);
                }
            } else {
                this.superClass = null;
            }
        }
        if ((index = definition.indexOf(60)) > -1) {
            this.isGenerics = true;
            int end = definition.lastIndexOf(62);
            String generic = definition.substring(index + 1, end);
            for (String gen : generic.split(",")) {
                boolean noImport = (gen = gen.trim()).contains("!");
                if (noImport) {
                    gen = gen.replaceAll("[!]", "");
                } else {
                    for (String part : gen.split(" ")) {
                        int period = part.lastIndexOf(46);
                        if (period < 0) continue;
                        this.imports.add(part);
                        gen = gen.replace(part.substring(0, period + 1), "");
                    }
                }
                this.generics.add(gen);
            }
            String prefix = definition.substring(0, index);
            definition = end < definition.length() - 1 ? prefix + definition.substring(end + 1) : prefix;
        } else {
            this.isGenerics = false;
        }
        definition = definition.trim();
        if (definition.contains(" ") && this.isClass) {
            throw new CompilationFailed("Found ambiguous class definition in " + original);
        }
        if (definition.length() == 0) {
            throw new CompilationFailed("Did not have a class name in class definition " + original);
        }
        if (Modifier.isStatic(modifier) && !this.isClass) {
            throw new CompilationFailed("A method cannot be both abstract and static!");
        }
        this.className = definition;
    }

    public String getClassName() {
        return this.className;
    }

    public int getPrivacy() {
        return this.modifier & 7;
    }

    public int getModifier() {
        return this.modifier;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String[] getGenerics() {
        return this.generics.toArray(new String[this.generics.size()]);
    }

    public String[] getImports() {
        return this.imports.toArray(new String[this.imports.size()]);
    }

    public String[] getInterfaces() {
        return this.interfaces.toArray(new String[this.interfaces.size()]);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifier);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifier);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifier);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifier);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifier);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifier);
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifier);
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean hasGenerics() {
        return this.isGenerics;
    }
}

