/*
 * Decompiled with CFR 0.152.
 */
package wetheinter.net.dev.io;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import wetheinter.net.dev.io.ClassBuffer;
import wetheinter.net.dev.io.JavaMetadata;
import wetheinter.net.dev.io.PrintBuffer;
import wetheinter.net.dev.io.SourceBuilder;
import wetheinter.net.dev.template.CompilationFailed;

public class MethodBuffer
extends PrintBuffer {
    private int modifier;
    protected SourceBuilder<?> context;
    private boolean once;
    private boolean useJsni = true;
    private String methodName;
    private final Set<String> generics;
    private final Set<String> parameters;
    private String returnType;

    public MethodBuffer(SourceBuilder<?> context) {
        this.context = context;
        this.generics = new HashSet<String>();
        this.parameters = new HashSet<String>();
    }

    @Override
    public String toString() {
        String suffix;
        String prefix;
        StringBuilder b = new StringBuilder('\n' + this.indent);
        b.append(Modifier.toString(this.modifier));
        b.append(" ");
        if (this.generics.size() > 0) {
            b.append("<");
            prefix = "";
            for (String generic : this.generics) {
                b.append(prefix);
                b.append(generic);
                prefix = ", ";
            }
            b.append("> ");
        }
        b.append(this.returnType);
        b.append(" ");
        b.append(this.methodName);
        b.append(" (");
        prefix = "";
        for (String parameter : this.parameters) {
            b.append(prefix);
            b.append(parameter);
            prefix = ", ";
        }
        b.append(") ");
        if (Modifier.isAbstract(this.modifier)) {
            prefix = ";\n";
            suffix = "";
        } else if (Modifier.isNative(this.modifier)) {
            if (this.useJsni) {
                prefix = "/*-{\n";
                suffix = '\n' + this.indent + "}-*/;";
            } else {
                prefix = ";\n";
                suffix = "";
            }
        } else {
            prefix = "{\n";
            suffix = '\n' + this.indent + "}\n";
        }
        return b.toString() + prefix + super.toString() + suffix;
    }

    public void setDefinition(String definition) {
        JavaMetadata metadata = new JavaMetadata(definition);
        this.modifier = metadata.getModifier();
        definition = metadata.getClassName();
        this.context.getImports().addImports(metadata.getImports());
        if (metadata.hasGenerics()) {
            String[] generic;
            this.generics.clear();
            for (String s : generic = metadata.getGenerics()) {
                this.generics.add(s);
            }
        }
        int ind = definition.indexOf(32);
        this.returnType = definition.substring(0, ind);
        definition = definition.substring(ind + 1);
        ind = this.returnType.lastIndexOf(46);
        if (ind > 0) {
            this.context.getImports().addImport(this.returnType);
            this.returnType = this.returnType.substring(ind + 1);
        }
        ind = definition.indexOf(40);
        assert (ind > 0);
        this.methodName = definition.substring(0, ind);
        definition = definition.substring(ind + 1, definition.lastIndexOf(41));
        for (String param : definition.split(",")) {
            ind = (param = param.trim()).lastIndexOf(46);
            if (ind > 0) {
                this.context.getImports().addImport(param.substring(0, param.indexOf(32)));
                param = param.substring(ind + 1);
            }
            this.parameters.add(param);
        }
        if (this.methodName.contains(" ")) {
            throw new CompilationFailed("Found ambiguous method definition in " + definition);
        }
        if (this.methodName.length() == 0) {
            throw new CompilationFailed("Did not have a class name in class definition " + definition);
        }
    }

    public void addParameters(String ... paramaters) {
        for (String parameter0 : paramaters) {
            for (String parameter : parameter0.split(",")) {
                int index = (parameter = parameter.trim()).lastIndexOf(46);
                if (index > 0) {
                    int end = parameter.lastIndexOf(32);
                    assert (end > 0);
                    String fqcn = parameter.substring(0, end);
                    this.context.getImports().addImport(fqcn);
                    this.parameters.add(parameter.substring(index + 1));
                    continue;
                }
                this.parameters.add(parameter);
            }
        }
    }

    public void addGenerics(String ... generics) {
        for (String generic : generics) {
            boolean noImport = (generic = generic.trim()).contains("!");
            if (noImport) {
                this.generics.add(generic.replace("!", ""));
                continue;
            }
            for (String part : generic.split(" ")) {
                int index = generic.lastIndexOf(".");
                if (index <= 0) continue;
                this.context.getImports().addImport(part);
                generic = generic.replace(part.substring(0, index + 1), "");
            }
            this.generics.add(generic);
        }
    }

    public ClassBuffer createInnerClass(String classDef) {
        ClassBuffer cls = new ClassBuffer(this.context);
        cls.setDefinition(classDef, classDef.trim().endsWith("{"));
        cls.indent = this.indent + "  ";
        assert (cls.privacy == 0) : "A local class cannot be " + Modifier.toString(cls.privacy);
        this.addToEnd(cls);
        return cls;
    }

    @Override
    protected void onAppend() {
        if (this.once) {
            this.once = false;
            this.onFirstAppend();
        }
        super.onAppend();
    }

    protected void onFirstAppend() {
    }

    public void setUseJsni(boolean useJsni) {
        this.useJsni = useJsni;
    }

    @Override
    public MethodBuffer append(boolean b) {
        super.append(b);
        return this;
    }

    @Override
    public MethodBuffer append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public MethodBuffer append(char[] str) {
        super.append(str);
        return this;
    }

    @Override
    public MethodBuffer append(char[] str, int offset, int len) {
        super.append(str, offset, len);
        return this;
    }

    @Override
    public MethodBuffer append(CharSequence s) {
        super.append(s);
        return this;
    }

    @Override
    public MethodBuffer append(CharSequence s, int start, int end) {
        super.append(s, start, end);
        return this;
    }

    @Override
    public MethodBuffer append(double d) {
        super.append(d);
        return this;
    }

    @Override
    public MethodBuffer append(float f) {
        super.append(f);
        return this;
    }

    @Override
    public MethodBuffer append(int i) {
        super.append(i);
        return this;
    }

    @Override
    public MethodBuffer append(long lng) {
        super.append(lng);
        return this;
    }

    @Override
    public MethodBuffer append(Object obj) {
        super.append(obj);
        return this;
    }

    @Override
    public MethodBuffer append(String str) {
        super.append(str);
        return this;
    }

    @Override
    public MethodBuffer indent() {
        super.indent();
        return this;
    }

    @Override
    public MethodBuffer indentln(char[] str) {
        super.indentln(str);
        return this;
    }

    @Override
    public MethodBuffer indentln(CharSequence s) {
        super.indentln(s);
        return this;
    }

    @Override
    public MethodBuffer indentln(Object obj) {
        super.indentln(obj);
        return this;
    }

    @Override
    public MethodBuffer indentln(String str) {
        super.indentln(str);
        return this;
    }

    @Override
    public MethodBuffer outdent() {
        super.outdent();
        return this;
    }

    @Override
    public MethodBuffer println() {
        super.println();
        return this;
    }

    @Override
    public MethodBuffer println(char[] str) {
        super.println(str);
        return this;
    }

    @Override
    public MethodBuffer println(CharSequence s) {
        super.println(s);
        return this;
    }

    @Override
    public MethodBuffer println(Object obj) {
        super.println(obj);
        return this;
    }

    @Override
    public MethodBuffer println(String str) {
        super.println(str);
        return this;
    }
}

