/*
 * Decompiled with CFR 0.152.
 */
package wetheinter.net.dev.io;

public class PrintBuffer {
    static final char NEW_LINE = '\n';
    static final String INDENT = "  ";
    StringBuilder target;
    String indent = "  ";
    PrintStack head;
    PrintStack tail;
    private boolean indented = false;

    public PrintBuffer() {
        this(new StringBuilder());
    }

    public PrintBuffer(PrintBuffer preamble) {
        this(new StringBuilder());
        this.head.buffer = preamble;
    }

    public PrintBuffer(StringBuilder target) {
        this.target = target;
        this.tail = this.head = new PrintStack();
    }

    protected void onAppend() {
    }

    public PrintBuffer append(Object obj) {
        this.onAppend();
        this.target.append(obj);
        return this;
    }

    public PrintBuffer append(String str) {
        this.onAppend();
        this.target.append(str);
        return this;
    }

    public PrintBuffer append(CharSequence s) {
        this.onAppend();
        this.target.append(s);
        return this;
    }

    public PrintBuffer append(CharSequence s, int start, int end) {
        this.onAppend();
        this.target.append(s, start, end);
        return this;
    }

    public PrintBuffer append(char[] str) {
        this.onAppend();
        this.target.append(str);
        return this;
    }

    public PrintBuffer append(char[] str, int offset, int len) {
        this.onAppend();
        this.target.append(str, offset, len);
        return this;
    }

    public PrintBuffer append(boolean b) {
        this.onAppend();
        this.target.append(b);
        return this;
    }

    public PrintBuffer append(char c) {
        this.onAppend();
        this.target.append(c);
        return this;
    }

    public PrintBuffer append(int i) {
        this.onAppend();
        this.target.append(i);
        return this;
    }

    public PrintBuffer append(long lng) {
        this.onAppend();
        this.target.append(lng);
        return this;
    }

    public PrintBuffer append(float f) {
        this.onAppend();
        this.target.append(f);
        return this;
    }

    public PrintBuffer append(double d) {
        this.onAppend();
        this.target.append(d);
        return this;
    }

    public PrintBuffer indent() {
        this.indent = this.indent + INDENT;
        return this;
    }

    private void printIndent() {
        if (!this.indented) {
            this.target.append(this.indent);
            this.indented = true;
        }
    }

    public PrintBuffer indentln(Object obj) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.target.append(obj);
        this.println();
        return this;
    }

    public PrintBuffer indentln(String str) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.append(str);
        this.println();
        return this;
    }

    public PrintBuffer indentln(CharSequence s) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.target.append(s);
        this.println();
        return this;
    }

    public PrintBuffer indentln(char[] str) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.target.append(str);
        this.println();
        return this;
    }

    public PrintBuffer outdent() {
        int end = Math.max(0, this.indent.length() - INDENT.length());
        this.indent = end > 0 ? this.indent.substring(0, end) : "";
        return this;
    }

    public PrintBuffer println() {
        this.onAppend();
        this.target.append('\n');
        this.indented = false;
        return this;
    }

    public PrintBuffer println(Object obj) {
        this.printIndent();
        this.onAppend();
        this.target.append(obj);
        this.println();
        return this;
    }

    public PrintBuffer println(String str) {
        this.printIndent();
        this.onAppend();
        this.append(str);
        this.println();
        return this;
    }

    public PrintBuffer println(CharSequence s) {
        this.printIndent();
        this.onAppend();
        this.target.append(s);
        this.println();
        return this;
    }

    public PrintBuffer println(char[] str) {
        this.printIndent();
        this.onAppend();
        this.target.append(str);
        this.println();
        return this;
    }

    public PrintBuffer addToBeginning(PrintBuffer buffer) {
        assert (this.notContained(buffer)) : "Infinite recursion!";
        PrintStack newHead = new PrintStack();
        newHead.next = this.head;
        newHead.buffer = buffer;
        this.head = newHead;
        return this;
    }

    public PrintBuffer addToEnd(PrintBuffer buffer) {
        assert (this.notContained(buffer)) : "Infinite recursion!";
        PrintStack newTail = new PrintStack();
        newTail.buffer = buffer;
        newTail.prefix = this.target.toString();
        this.target.setLength(0);
        this.tail.next = newTail;
        this.tail = newTail;
        return this;
    }

    private boolean notContained(PrintBuffer buffer) {
        if (buffer == this) {
            System.err.println("Trying to add a buffer to itself");
            return false;
        }
        PrintStack next = this.head;
        while (next != null) {
            if (next.buffer == buffer) {
                System.err.println("Trying to add a buffer that is already a child");
                return false;
            }
            next = next.next;
        }
        next = buffer.head;
        while (next != null) {
            if (next.buffer == this) {
                System.err.println("Trying to add an ancestor to a child");
                return false;
            }
            next = next.next;
        }
        return true;
    }

    protected String header() {
        return "";
    }

    protected String footer() {
        return "";
    }

    public String toString() {
        StringBuilder body = new StringBuilder(this.header());
        PrintStack next = this.head;
        while (next != null) {
            if (next.prefix.length() > 0) {
                body.append(next.prefix);
            }
            if (next.buffer != null) {
                body.append(next.buffer);
            }
            next = next.next;
        }
        body.append((CharSequence)this.target);
        return body + this.footer();
    }

    protected static final class PrintStack {
        PrintStack next;
        String prefix = "";
        PrintBuffer buffer;

        protected PrintStack() {
        }

        public PrintStack push(String prefix, PrintBuffer b) {
            PrintStack node = new PrintStack();
            node.prefix = prefix == null ? "" : prefix;
            node.buffer = b;
            assert (this.next == null) : "Pushing to the same stack twice overwrites old value.";
            this.next = node;
            return node;
        }
    }
}

