/*
 * Decompiled with CFR 0.152.
 */
package wetheinter.net.dev.template;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import wetheinter.net.dev.io.ImportSection;
import wetheinter.net.dev.io.SourceBuilder;
import wetheinter.net.dev.template.CompilationFailed;
import wetheinter.net.dev.template.ProcessingInstructionOptions;
import wetheinter.net.dev.template.TemplateClassGenerator;
import wetheinter.net.dev.template.TemplateGeneratorOptions;
import wetheinter.net.dev.template.TemplateProcessingInstruction;

public class TemplateToJava {
    private static final String templateSuffix = System.getProperty("template.suffix", ".x");
    private static final Pattern lineMatcher = Pattern.compile("\\s*//.*//\\s*");
    private static final Charset utf8 = Charset.forName("UTF-8");
    private Class<?> generatorClass;
    private final Map<Class<?>, Object> generators = new HashMap();

    public static void main(String[] templates) {
        TemplateToJava generator = new TemplateToJava();
        PrintWriterTreeLogger logger = new PrintWriterTreeLogger();
        TemplateGeneratorOptions options = new TemplateGeneratorOptions();
        if (options.processArgs(templates)) {
            logger.setMaxDetail(options.getLogLevel());
            for (String template : options.getTemplates()) {
                generator.generate((TreeLogger)logger, template, options);
            }
        } else {
            throw new RuntimeException("Invalid arguments specified; see console logs for help.");
        }
    }

    private void generate(TreeLogger logger, String template, TemplateGeneratorOptions options) {
        SourceBuilder<?> context = options.getContext(logger, template);
        try {
            String line;
            InputStream input;
            if (new File(template).exists()) {
                input = new FileInputStream(template);
            } else {
                URL url = this.getClass().getClassLoader().getResource(template);
                if (url == null && (url = ClassLoader.getSystemResource(template)) == null) {
                    logger.log(TreeLogger.Type.ERROR, "You requested code generation for template " + template + ", but the file could not be found.");
                    throw new CompilationFailed();
                }
                input = url.openStream();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                if (lineMatcher.matcher(line).matches()) {
                    this.applyTemplate(logger, reader, context, options, line.trim());
                    continue;
                }
                context.getBuffer().append(line).append('\n');
            }
            this.exportClass(logger, template, context, options);
        }
        catch (Exception e) {
            throw new CompilationFailed("Unable to generate java source file for template " + template, e);
        }
    }

    private void exportClass(TreeLogger logger, String filename, SourceBuilder<?> context, TemplateGeneratorOptions opts) {
        String repackage;
        File outputFile = new File(opts.getOutputLocation());
        if (filename.endsWith(templateSuffix)) {
            filename = filename.substring(0, filename.length() - templateSuffix.length());
        }
        if (!filename.endsWith(".java")) {
            filename = filename + ".java";
        }
        if ((repackage = context.getRepackage()) != null) {
            filename = repackage.replace('.', File.separatorChar) + File.separator + filename.substring(filename.lastIndexOf(47));
        }
        outputFile = new File(outputFile.getAbsoluteFile(), filename);
        outputFile.getParentFile().mkdirs();
        try {
            logger.log(TreeLogger.Type.INFO, "Writing generated output to " + outputFile.getAbsolutePath());
            ByteArrayInputStream in = new ByteArrayInputStream(context.toString().getBytes(utf8));
            FileOutputStream out = new FileOutputStream(outputFile);
            Util.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            logger.log(TreeLogger.Type.ERROR, "Error streaming generated output to file " + outputFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private void applyTemplate(TreeLogger logger, BufferedReader input, SourceBuilder<?> context, TemplateGeneratorOptions options, String line) throws IOException {
        if (!lineMatcher.matcher(line).matches()) {
            context.getBuffer().println(line);
            return;
        }
        line = line.substring(2, line.length() - 2);
        if (line.startsWith("@")) {
            String[] parts = this.stripBrackets(line.substring(1), input);
            String command = parts[1];
            switch (TemplateProcessingInstruction.valueOf(parts[0])) {
                case classDefinition: {
                    String next = input.readLine();
                    if (next.contains("class ") || next.contains("interface ")) {
                        context.setClassDefinition(next, true);
                        context.setClassDefinition(command, true);
                        break;
                    }
                    context.setClassDefinition(command, false);
                    this.applyTemplate(logger, input, context, options, next);
                    return;
                }
                case generateWith: {
                    logger.log(TreeLogger.Type.TRACE, "Setting generator to " + command);
                    try {
                        this.generatorClass = Class.forName(command);
                        Object generator = this.inject(this.generatorClass);
                        if (generator instanceof TemplateClassGenerator) {
                            ((TemplateClassGenerator)generator).initialize(logger, options);
                        }
                        this.generators.put(this.generatorClass, generator);
                        break;
                    }
                    catch (Exception e) {
                        throw new CompilationFailed("Could not instantiate requested generator " + command + "; " + "please ensure this class is available on your code generation classpath.", e);
                    }
                }
                case emulated: {
                    String packageStatement = input.readLine().trim();
                    if (!packageStatement.startsWith("package ")) {
                        throw new CompilationFailed("An //@emulated()// command must appear on the line directly above the package statement.");
                    }
                    String repackage = packageStatement.substring(8);
                    logger.log(TreeLogger.Type.TRACE, "Repackaging emulated source into " + command + "." + repackage);
                    context.getBuffer().append("package " + repackage);
                    context.setPackage(command + "." + repackage);
                    break;
                }
                case repackaged: {
                    String packageStatement = input.readLine().trim();
                    if (!packageStatement.startsWith("package ")) {
                        throw new CompilationFailed("An //@repackage()// command must appear on the line directly above the package statement.");
                    }
                    String repackage = command + ";";
                    logger.log(TreeLogger.Type.TRACE, "Repackaging source into " + repackage);
                    context.getBuffer().append("package " + repackage);
                    context.setPackage(repackage);
                    break;
                }
                case imports: {
                    String existing;
                    ImportSection imports = context.getImports();
                    while ((existing = input.readLine()) != null) {
                        if (existing.trim().length() == 0) continue;
                        if (existing.startsWith("import ")) {
                            imports.addImport(existing);
                            continue;
                        }
                        this.applyTemplate(logger, input, context, options, existing);
                        return;
                    }
                    break;
                }
                case skipline: {
                    int lines = Integer.parseInt(command);
                    while (lines-- > 0) {
                        input.readLine();
                    }
                    break;
                }
            }
        } else {
            Method method;
            String[] parts = this.stripBrackets(line, input);
            if (this.generatorClass == null) {
                throw new CompilationFailed("TemplateToJava encountered a call to a template method, " + line + ", before a generator was called.  " + "\nPlease add //@generateWith(package.Class)// to the top of your template");
            }
            Object generator = this.generators.get(this.generatorClass);
            if (generator == null) {
                throw new CompilationFailed("TemplateToJava encountered a call to a template method, " + line + ", before a generator was loaded.  " + "\nPlease add //@generateWith(package.Class)// to the top of your template");
            }
            try {
                method = this.generatorClass.getDeclaredMethod(parts[0], TreeLogger.class, SourceBuilder.class, String.class);
                method.setAccessible(true);
            }
            catch (Exception e) {
                throw new CompilationFailed("Unable to find instance method " + parts[0] + " in generator class " + this.generatorClass.getName(), e);
            }
            try {
                method.invoke(generator, logger, context, parts[1]);
                int skipLines = context.getLinesToSkip();
                while (skipLines-- > 0) {
                    input.readLine();
                }
            }
            catch (Exception e) {
                throw new CompilationFailed("Failure invoking instance method " + parts[0] + " in generator class " + this.generatorClass.getName(), e);
            }
        }
    }

    protected Object inject(Class<?> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new CompilationFailed("Unable to instantiate class " + cls, e);
        }
    }

    private String[] stripBrackets(String line, BufferedReader input) {
        int start = line.indexOf(40);
        int end = line.lastIndexOf(41);
        if (start < 0 || end < 0) {
            throw new CompilationFailed("The command " + line + " was malformed.  Expected () brackets in " + line);
        }
        String body = line.substring(0, start).trim();
        String params = line.substring(start + 1, end).trim();
        if (end < line.length() - 1) {
            try {
                ProcessingInstructionOptions opts;
                String extra = line.substring(end + 1).trim();
                if (extra.length() > 0 && (opts = new ProcessingInstructionOptions()).processArgs(extra.split(" "))) {
                    if (opts.wordsToSkip > 0) {
                        while (input.read() == 32) {
                        }
                    }
                    while (opts.wordsToSkip-- > 0) {
                        while (input.read() != 32) {
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new String[]{body, params};
    }
}

