/*
 * Decompiled with CFR 0.152.
 */
package net.whitbeck.rdbparser;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.whitbeck.rdbparser.LazyList;

final class IntSet
extends LazyList<byte[]> {
    private static final Charset ASCII = Charset.forName("ASCII");
    private final byte[] envelope;

    IntSet(byte[] envelope) {
        this.envelope = envelope;
    }

    private int readIntAt(int pos) {
        return (this.envelope[pos++] & 0xFF) << 0 | (this.envelope[pos++] & 0xFF) << 8 | (this.envelope[pos++] & 0xFF) << 16 | (this.envelope[pos++] & 0xFF) << 24;
    }

    private int getEncoding() {
        return this.readIntAt(0);
    }

    private int getNumInts() {
        return this.readIntAt(4);
    }

    private List<byte[]> read16BitInts(int num) {
        ArrayList<byte[]> ints = new ArrayList<byte[]>(num);
        int pos = 8;
        for (int i = 0; i < num; ++i) {
            long val = ((long)this.envelope[pos++] & 0xFFL) << 0 | (long)this.envelope[pos++] << 8;
            ints.add(String.valueOf(val).getBytes(ASCII));
        }
        return ints;
    }

    private List<byte[]> read32BitInts(int num) {
        ArrayList<byte[]> ints = new ArrayList<byte[]>(num);
        int pos = 8;
        for (int i = 0; i < num; ++i) {
            long val = ((long)this.envelope[pos++] & 0xFFL) << 0 | ((long)this.envelope[pos++] & 0xFFL) << 8 | ((long)this.envelope[pos++] & 0xFFL) << 16 | (long)this.envelope[pos++] << 24;
            ints.add(String.valueOf(val).getBytes(ASCII));
        }
        return ints;
    }

    private List<byte[]> read64BitInts(int num) {
        ArrayList<byte[]> ints = new ArrayList<byte[]>(num);
        int pos = 8;
        for (int i = 0; i < num; ++i) {
            long val = ((long)this.envelope[pos++] & 0xFFL) << 0 | ((long)this.envelope[pos++] & 0xFFL) << 8 | ((long)this.envelope[pos++] & 0xFFL) << 16 | ((long)this.envelope[pos++] & 0xFFL) << 24 | ((long)this.envelope[pos++] & 0xFFL) << 32 | ((long)this.envelope[pos++] & 0xFFL) << 40 | ((long)this.envelope[pos++] & 0xFFL) << 48 | (long)this.envelope[pos++] << 56;
            ints.add(String.valueOf(val).getBytes(ASCII));
        }
        return ints;
    }

    @Override
    protected List<byte[]> realize() {
        int encoding = this.getEncoding();
        int num = this.getNumInts();
        switch (encoding) {
            case 2: {
                return this.read16BitInts(num);
            }
            case 4: {
                return this.read32BitInts(num);
            }
            case 8: {
                return this.read64BitInts(num);
            }
        }
        throw new IllegalStateException("Unknown intset encoding");
    }
}

