/*
 * Decompiled with CFR 0.152.
 */
package net.whitbeck.rdbparser;

import java.util.List;
import net.whitbeck.rdbparser.Entry;
import net.whitbeck.rdbparser.EntryType;
import net.whitbeck.rdbparser.StringUtils;
import net.whitbeck.rdbparser.ValueType;

public final class KeyValuePair
implements Entry {
    byte[] key;
    ValueType valueType;
    List<byte[]> values;
    byte[] expireTime;
    Long idle;
    Integer freq;

    public byte[] getKey() {
        return this.key;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public EntryType getType() {
        return EntryType.KEY_VALUE_PAIR;
    }

    public List<byte[]> getValues() {
        return this.values;
    }

    public Long getExpireTime() {
        if (this.expireTime == null) {
            return null;
        }
        switch (this.expireTime.length) {
            case 4: {
                return this.parseExpireTime4Bytes();
            }
            case 8: {
                return this.parseExpireTime8Bytes();
            }
        }
        throw new IllegalStateException("Invalid number of expire time bytes");
    }

    private long parseExpireTime4Bytes() {
        return 1000L * (((long)this.expireTime[3] & 0xFFL) << 24 | ((long)this.expireTime[2] & 0xFFL) << 16 | ((long)this.expireTime[1] & 0xFFL) << 8 | ((long)this.expireTime[0] & 0xFFL) << 0);
    }

    private long parseExpireTime8Bytes() {
        return ((long)this.expireTime[7] & 0xFFL) << 56 | ((long)this.expireTime[6] & 0xFFL) << 48 | ((long)this.expireTime[5] & 0xFFL) << 40 | ((long)this.expireTime[4] & 0xFFL) << 32 | ((long)this.expireTime[3] & 0xFFL) << 24 | ((long)this.expireTime[2] & 0xFFL) << 16 | ((long)this.expireTime[1] & 0xFFL) << 8 | ((long)this.expireTime[0] & 0xFFL) << 0;
    }

    public Integer getFreq() {
        return this.freq;
    }

    public Long getIdle() {
        return this.idle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)EntryType.KEY_VALUE_PAIR);
        sb.append(" (key: ");
        sb.append(StringUtils.getPrintableString(this.key));
        if (this.expireTime != null) {
            sb.append(", expire time: ");
            sb.append(this.getExpireTime());
        }
        sb.append(", ");
        int len = this.getValues().size();
        sb.append(len);
        if (len == 1) {
            sb.append(" value)");
        } else {
            sb.append(" values)");
        }
        return sb.toString();
    }
}

