/*
 * Decompiled with CFR 0.152.
 */
package net.whitbeck.rdbparser;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.whitbeck.rdbparser.LazyList;

class ListpackList
extends LazyList<byte[]> {
    private static final Charset ASCII = Charset.forName("ASCII");
    private static final int LP_ENCODING_7BIT_UINT = 0;
    private static final int LP_ENCODING_7BIT_UINT_MASK = 128;
    private static final int LP_ENCODING_6BIT_STR = 128;
    private static final int LP_ENCODING_6BIT_STR_MASK = 192;
    private static final int LP_ENCODING_13BIT_INT = 192;
    private static final int LP_ENCODING_13BIT_INT_MASK = 224;
    private static final int LP_ENCODING_12BIT_STR = 224;
    private static final int LP_ENCODING_12BIT_STR_MASK = 240;
    private static final int LP_ENCODING_16BIT_INT = 241;
    private static final int LP_ENCODING_16BIT_INT_MASK = 255;
    private static final int LP_ENCODING_24BIT_INT = 242;
    private static final int LP_ENCODING_24BIT_INT_MASK = 255;
    private static final int LP_ENCODING_32BIT_INT = 243;
    private static final int LP_ENCODING_32BIT_INT_MASK = 255;
    private static final int LP_ENCODING_64BIT_INT = 244;
    private static final int LP_ENCODING_64BIT_INT_MASK = 255;
    private static final int LP_ENCODING_32BIT_STR = 240;
    private static final int LP_ENCODING_32BIT_STR_MASK = 255;
    private final byte[] envelope;

    ListpackList(byte[] envelope) {
        this.envelope = envelope;
    }

    @Override
    protected List<byte[]> realize() {
        ListpackParser listpackParser;
        ListpackParser listpackParser2 = listpackParser = new ListpackParser();
        listpackParser2.pos = listpackParser2.pos + 4;
        int numElements = (this.envelope[listpackParser.pos++] & 0xFF) << 0 | (this.envelope[listpackParser.pos++] & 0xFF) << 8;
        for (int i = 0; i < numElements; ++i) {
            listpackParser.decodeElement();
        }
        if ((this.envelope[listpackParser.pos] & 0xFF) != 255) {
            throw new IllegalStateException("Listpack did not end with 0xff byte.");
        }
        return listpackParser.list;
    }

    private class ListpackParser {
        private int pos = 0;
        private List<byte[]> list = new ArrayList<byte[]>();

        private ListpackParser() {
        }

        private void decodeElement() {
            long negMax;
            long negStart;
            long val;
            int b = ListpackList.this.envelope[this.pos++] & 0xFF;
            int strLen = 0;
            if ((b & 0xC0) == 128) {
                strLen = b & 0xFFFFFF3F;
            } else if ((b & 0xF0) == 224) {
                strLen = ListpackList.this.envelope[this.pos++] & 0xFF | (b & 0xFF & 0xFFFFFF0F) << 8;
            } else if ((b & 0xFF) == 240) {
                strLen = (ListpackList.this.envelope[this.pos++] & 0xFF) << 0 | (ListpackList.this.envelope[this.pos++] & 0xFF) << 8 | (ListpackList.this.envelope[this.pos++] & 0xFF) << 16 | ListpackList.this.envelope[this.pos++] << 24;
            }
            if (strLen > 0) {
                this.pos += strLen;
                this.list.add(Arrays.copyOfRange(ListpackList.this.envelope, this.pos - strLen, this.pos));
                this.pos += this.getLenBytes(strLen);
                return;
            }
            if ((b & 0x80) == 0) {
                this.list.add(String.valueOf(b & 0xFFFFFF7F).getBytes(ASCII));
                ++this.pos;
                return;
            }
            if ((b & 0xE0) == 192) {
                val = (b & 0xFF & 0xFFFFFF1F) << 8 | ListpackList.this.envelope[this.pos++] & 0xFF;
                negStart = 4096L;
                negMax = 8191L;
            } else if ((b & 0xFF) == 241) {
                val = (long)ListpackList.this.envelope[this.pos++] & 0xFFL | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 8;
                negStart = 32768L;
                negMax = 65535L;
            } else if ((b & 0xFF) == 242) {
                val = (long)ListpackList.this.envelope[this.pos++] & 0xFFL | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 8 | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 16;
                negStart = 0x800000L;
                negMax = 0xFFFFFFL;
            } else if ((b & 0xFF) == 243) {
                val = (long)ListpackList.this.envelope[this.pos++] & 0xFFL | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 8 | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 16 | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 24;
                negStart = 0x80000000L;
                negMax = 0xFFFFFFFFL;
            } else {
                if ((b & 0xFF) == 244) {
                    long val2 = (long)ListpackList.this.envelope[this.pos++] & 0xFFL | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 8 | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 16 | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 24 | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 32 | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 40 | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 48 | ((long)ListpackList.this.envelope[this.pos++] & 0xFFL) << 56;
                    this.list.add(String.valueOf(val2).getBytes(ASCII));
                    ++this.pos;
                    return;
                }
                throw new RuntimeException("Invalid listpack envelope encoding");
            }
            if (val >= negStart) {
                long diff;
                val = diff = negMax - val;
                val = -val - 1L;
            }
            ++this.pos;
            this.list.add(String.valueOf(val).getBytes(ASCII));
        }

        private int getLenBytes(int len) {
            if (len < 128) {
                return 1;
            }
            if (len < 16384) {
                return 2;
            }
            if (len < 0x200000) {
                return 3;
            }
            if (len < 0x10000000) {
                return 4;
            }
            return 5;
        }
    }
}

