/*
 * Decompiled with CFR 0.152.
 */
package net.whitbeck.rdbparser;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.whitbeck.rdbparser.DoubleBytes;
import net.whitbeck.rdbparser.LazyList;
import net.whitbeck.rdbparser.ListpackList;

final class SortedSetAsListpack
extends LazyList<byte[]> {
    private static final Charset ASCII = Charset.forName("ASCII");
    private static final byte[] POS_INF_BYTES = "inf".getBytes(ASCII);
    private static final byte[] NEG_INF_BYTES = "-inf".getBytes(ASCII);
    private static final byte[] NAN_BYTES = "nan".getBytes(ASCII);
    private final byte[] envelope;

    SortedSetAsListpack(byte[] envelope) {
        this.envelope = envelope;
    }

    @Override
    protected List<byte[]> realize() {
        List<byte[]> values = new ListpackList(this.envelope).realize();
        ListIterator<byte[]> i = values.listIterator();
        while (i.hasNext()) {
            byte[] val = i.next();
            if (Arrays.equals(val, POS_INF_BYTES)) {
                i.set(DoubleBytes.POSITIVE_INFINITY);
                continue;
            }
            if (Arrays.equals(val, NEG_INF_BYTES)) {
                i.set(DoubleBytes.NEGATIVE_INFINITY);
                continue;
            }
            if (!Arrays.equals(val, NAN_BYTES)) continue;
            i.set(DoubleBytes.NaN);
        }
        return values;
    }
}

