/*
 * Decompiled with CFR 0.152.
 */
package net.whitbeck.rdbparser;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.whitbeck.rdbparser.LazyList;

final class ZipList
extends LazyList<byte[]> {
    private static final Charset ASCII = Charset.forName("ASCII");
    private final byte[] envelope;

    ZipList(byte[] envelope) {
        this.envelope = envelope;
    }

    @Override
    protected List<byte[]> realize() {
        int pos = 8;
        int num = (this.envelope[pos++] & 0xFF) << 0 | (this.envelope[pos++] & 0xFF) << 8;
        ArrayList<byte[]> list = new ArrayList<byte[]>(num);
        block16: for (int idx = 0; idx < num; ++idx) {
            int prevLen;
            if ((prevLen = this.envelope[pos++] & 0xFF) > 253) {
                pos += 4;
            }
            int special = this.envelope[pos++] & 0xFF;
            int top2bits = special >> 6;
            switch (top2bits) {
                case 0: {
                    int len = special & 0x3F;
                    byte[] buf = new byte[len];
                    System.arraycopy(this.envelope, pos, buf, 0, len);
                    pos += len;
                    list.add(buf);
                    continue block16;
                }
                case 1: {
                    int len = (special & 0x3F) << 8 | this.envelope[pos++] & 0xFF;
                    byte[] buf = new byte[len];
                    System.arraycopy(this.envelope, pos, buf, 0, len);
                    pos += len;
                    list.add(buf);
                    continue block16;
                }
                case 2: {
                    int len = (this.envelope[pos++] & 0xFF) << 24 | (this.envelope[pos++] & 0xFF) << 16 | (this.envelope[pos++] & 0xFF) << 8 | (this.envelope[pos++] & 0xFF) << 0;
                    byte[] buf = new byte[len];
                    System.arraycopy(this.envelope, pos, buf, 0, len);
                    pos += len;
                    list.add(buf);
                    continue block16;
                }
                case 3: {
                    int flag = (special & 0x30) >> 4;
                    switch (flag) {
                        case 0: {
                            long val = (long)this.envelope[pos++] & 0xFFL | (long)this.envelope[pos++] << 8;
                            list.add(String.valueOf(val).getBytes(ASCII));
                            continue block16;
                        }
                        case 1: {
                            long val = ((long)this.envelope[pos++] & 0xFFL) << 0 | ((long)this.envelope[pos++] & 0xFFL) << 8 | ((long)this.envelope[pos++] & 0xFFL) << 16 | (long)this.envelope[pos++] << 24;
                            list.add(String.valueOf(val).getBytes(ASCII));
                            continue block16;
                        }
                        case 2: {
                            long val = ((long)this.envelope[pos++] & 0xFFL) << 0 | ((long)this.envelope[pos++] & 0xFFL) << 8 | ((long)this.envelope[pos++] & 0xFFL) << 16 | ((long)this.envelope[pos++] & 0xFFL) << 24 | ((long)this.envelope[pos++] & 0xFFL) << 32 | ((long)this.envelope[pos++] & 0xFFL) << 40 | ((long)this.envelope[pos++] & 0xFFL) << 48 | (long)this.envelope[pos++] << 56;
                            list.add(String.valueOf(val).getBytes(ASCII));
                            continue block16;
                        }
                        case 3: {
                            long val;
                            int loBits = special & 0xF;
                            switch (loBits) {
                                case 0: {
                                    val = ((long)this.envelope[pos++] & 0xFFL) << 0 | ((long)this.envelope[pos++] & 0xFFL) << 8 | (long)this.envelope[pos++] << 16;
                                    list.add(String.valueOf(val).getBytes(ASCII));
                                    continue block16;
                                }
                                case 14: {
                                    val = this.envelope[pos++];
                                    list.add(String.valueOf(val).getBytes(ASCII));
                                    continue block16;
                                }
                            }
                            list.add(String.valueOf(loBits - 1).getBytes(ASCII));
                            continue block16;
                        }
                    }
                    continue block16;
                }
            }
        }
        return list;
    }
}

