/*
 * Decompiled with CFR 0.152.
 */
package net.whitbeck.rdbparser;

import java.util.ArrayList;
import java.util.List;
import net.whitbeck.rdbparser.LazyList;

final class ZipMap
extends LazyList<byte[]> {
    private final byte[] envelope;

    ZipMap(byte[] envelope) {
        this.envelope = envelope;
    }

    @Override
    protected List<byte[]> realize() {
        int b;
        int zmlen;
        ArrayList<byte[]> list;
        int pos = 0;
        ArrayList<Object> arrayList = list = (zmlen = this.envelope[pos++] & 0xFF) < 254 ? new ArrayList<byte[]>(2 * zmlen) : new ArrayList();
        while ((b = this.envelope[pos++] & 0xFF) != 255) {
            int len = 0;
            len = b < 253 ? b : (this.envelope[pos++] & 0xFF) << 24 | (this.envelope[pos++] & 0xFF) << 16 | (this.envelope[pos++] & 0xFF) << 8 | (this.envelope[pos++] & 0xFF) << 0;
            byte[] buf = new byte[len];
            System.arraycopy(this.envelope, pos, buf, 0, len);
            pos += len;
            list.add(buf);
            b = this.envelope[pos++] & 0xFF;
            len = 0;
            len = b < 253 ? b : (this.envelope[pos++] & 0xFF) << 24 | (this.envelope[pos++] & 0xFF) << 16 | (this.envelope[pos++] & 0xFF) << 8 | (this.envelope[pos++] & 0xFF) << 0;
            int free = this.envelope[pos++] & 0xFF;
            buf = new byte[len];
            System.arraycopy(this.envelope, pos, buf, 0, len);
            pos += len + free;
            list.add(buf);
        }
        return list;
    }
}

