/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.util.ModbusUtil;

public abstract class ModbusMessageImpl
implements ModbusMessage {
    private int m_TransactionID = 0;
    private int m_ProtocolID = 0;
    private int m_DataLength;
    private int m_UnitID = 0;
    private int m_FunctionCode;
    private boolean m_Headless = false;

    public boolean isHeadless() {
        return this.m_Headless;
    }

    public void setHeadless() {
        this.m_Headless = true;
    }

    protected void setHeadless(boolean b) {
        this.m_Headless = b;
    }

    public int getTransactionID() {
        return this.m_TransactionID;
    }

    public void setTransactionID(int tid) {
        this.m_TransactionID = tid;
    }

    public int getProtocolID() {
        return this.m_ProtocolID;
    }

    public void setProtocolID(int pid) {
        this.m_ProtocolID = pid;
    }

    public int getDataLength() {
        return this.m_DataLength;
    }

    public void setDataLength(int length) {
        this.m_DataLength = length + 2;
    }

    public int getUnitID() {
        return this.m_UnitID;
    }

    public void setUnitID(int num) {
        this.m_UnitID = num;
    }

    public int getFunctionCode() {
        return this.m_FunctionCode;
    }

    protected void setFunctionCode(int code) {
        this.m_FunctionCode = code;
    }

    public void writeTo(DataOutput dout) throws IOException {
        if (!this.isHeadless()) {
            dout.writeShort(this.getTransactionID());
            dout.writeShort(this.getProtocolID());
            dout.writeShort(this.getDataLength());
        }
        dout.writeByte(this.getUnitID());
        dout.writeByte(this.getFunctionCode());
        this.writeData(dout);
    }

    public abstract void writeData(DataOutput var1) throws IOException;

    public void readFrom(DataInput din) throws IOException {
        if (!this.isHeadless()) {
            this.setTransactionID(din.readUnsignedShort());
            this.setProtocolID(din.readUnsignedShort());
            this.m_DataLength = din.readUnsignedShort();
        }
        this.setUnitID(din.readUnsignedByte());
        this.setFunctionCode(din.readUnsignedByte());
        this.readData(din);
    }

    public abstract void readData(DataInput var1) throws IOException;

    public int getOutputLength() {
        int l = 2 + this.getDataLength();
        if (!this.isHeadless()) {
            l += 6;
        }
        return l;
    }

    public String getHexMessage() {
        return ModbusUtil.toHex(this);
    }
}

