/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.Iterator;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Address;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class ADRItemHandler
implements ItemHandler {
    ADRItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        int i;
        boolean preferred = false;
        String[] components = StringUtil.split(item.getDecodedValue(), ";");
        Address adr = Pim.getContactModelFactory().createAddress();
        block9: for (i = 0; i < components.length; ++i) {
            switch (i) {
                case 0: {
                    adr.setPostBox(components[0]);
                    continue block9;
                }
                case 1: {
                    adr.setExtended(components[1]);
                    continue block9;
                }
                case 2: {
                    adr.setStreet(components[2]);
                    continue block9;
                }
                case 3: {
                    adr.setCity(components[3]);
                    continue block9;
                }
                case 4: {
                    adr.setRegion(components[4]);
                    continue block9;
                }
                case 5: {
                    adr.setPostalCode(components[5]);
                    continue block9;
                }
                case 6: {
                    adr.setCountry(components[6]);
                }
            }
        }
        components = item.getParameter("TYPE");
        if (components == null) {
            components = item.getParameter("DEFAULT");
        }
        if (components != null) {
            for (i = 0; i < components.length; ++i) {
                String type = components[i].toUpperCase();
                if (type.equals("DOM")) {
                    adr.setDomestic(true);
                    continue;
                }
                if (type.equals("INTL")) {
                    adr.setInternational(true);
                    continue;
                }
                if (type.equals("POSTAL")) {
                    adr.setPostal(true);
                    continue;
                }
                if (type.equals("PARCEL")) {
                    adr.setParcel(true);
                    continue;
                }
                if (type.equals("HOME")) {
                    adr.setHome(true);
                    continue;
                }
                if (type.equals("WORK")) {
                    adr.setWork(true);
                    continue;
                }
                if (!type.equals("PREF")) continue;
                preferred = true;
            }
        } else {
            adr.setInternational(true);
            adr.setPostal(true);
            adr.setParcel(true);
            adr.setWork(true);
        }
        ct.addAddress(adr);
        if (preferred) {
            ct.setPreferredAddress(adr);
        }
    }

    public versitItem[] createItems(Contact ct) {
        versitItem[] items = new versitItem[ct.getAddressCount()];
        int i = 0;
        Iterator iter = ct.getAddresses();
        while (iter.hasNext()) {
            Address adr = (Address)iter.next();
            if (adr == null) {
                return null;
            }
            String pobox = adr.getPostBox();
            String ext = adr.getExtended();
            String street = adr.getStreet();
            String region = adr.getRegion();
            String city = adr.getCity();
            String zip = adr.getPostalCode();
            String country = adr.getCountry();
            StringBuffer sbuf = new StringBuffer();
            versitItem item = new versitItem("ADR");
            if (adr.isDomestic()) {
                item.addParameter("TYPE", "DOM");
            }
            if (adr.isInternational()) {
                item.addParameter("TYPE", "INTL");
            }
            if (adr.isPostal()) {
                item.addParameter("TYPE", "POSTAL");
            }
            if (adr.isParcel()) {
                item.addParameter("TYPE", "PARCEL");
            }
            if (adr.isHome()) {
                item.addParameter("TYPE", "HOME");
            }
            if (adr.isWork()) {
                item.addParameter("TYPE", "WORK");
            }
            if (ct.isPreferredAddress(adr)) {
                item.addParameter("TYPE", "PREF");
            }
            if (StringUtil.isValidString(pobox)) {
                sbuf.append(pobox);
            }
            sbuf.append(";");
            if (StringUtil.isValidString(ext)) {
                sbuf.append(EncodingUtility.encodeLineBreaks(ext));
            }
            sbuf.append(";");
            if (StringUtil.isValidString(street)) {
                sbuf.append(EncodingUtility.encodeLineBreaks(street));
            }
            sbuf.append(";");
            if (StringUtil.isValidString(city)) {
                sbuf.append(city);
            }
            sbuf.append(";");
            if (StringUtil.isValidString(region)) {
                sbuf.append(region);
            }
            sbuf.append(";");
            if (StringUtil.isValidString(zip)) {
                sbuf.append(zip);
            }
            sbuf.append(";");
            if (StringUtil.isValidString(country)) {
                sbuf.append(country);
            }
            item.setValue(sbuf.toString());
            items[i] = item;
            ++i;
        }
        return items;
    }
}

