/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.Iterator;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Communications;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.EmailAddress;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class EMAILItemHandler
implements ItemHandler {
    EMAILItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        boolean preferred = false;
        EmailAddress email = Pim.getContactModelFactory().createEmailAddress();
        email.setAddress(item.getDecodedValue());
        String[] components = item.getParameter("TYPE");
        if (components == null) {
            components = item.getParameter("DEFAULT");
        }
        if (components != null && components.length > 0) {
            for (int i = 0; i < components.length; ++i) {
                if (components[i].equals("PREF")) {
                    preferred = true;
                    continue;
                }
                email.setType(components[i]);
            }
        } else {
            email.setType("INTERNET");
        }
        Communications comm = ct.getCommunications();
        if (comm == null) {
            comm = Pim.getContactModelFactory().createCommunications();
            ct.setCommunications(comm);
        }
        comm.addEmailAddress(email);
        if (preferred) {
            comm.setPreferredEmailAddress(email);
        }
    }

    public versitItem[] createItems(Contact ct) {
        if (!ct.hasCommunications()) {
            return new versitItem[0];
        }
        Communications comm = ct.getCommunications();
        versitItem[] items = new versitItem[comm.getEmailAddressCount()];
        int i = 0;
        Iterator iter = comm.getEmailAddresses();
        while (iter.hasNext()) {
            EmailAddress email = (EmailAddress)iter.next();
            String address = email.getAddress();
            String type = email.getType();
            if (!StringUtil.isValidString(address)) {
                return null;
            }
            versitItem item = new versitItem("EMAIL");
            item.setValue(address);
            if (comm.isPreferredEmailAddress(email)) {
                item.addParameter("TYPE", "PREF");
            }
            if (StringUtil.isValidString(type)) {
                item.addParameter("TYPE", type);
            }
            items[i] = item;
            ++i;
        }
        return items;
    }
}

