/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Key;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.versitio.versitItem;

class KEYItemHandler
implements ItemHandler {
    KEYItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        Key key = Pim.getContactModelFactory().createKey();
        String[] paramvalues = null;
        paramvalues = item.getParameter("VALUE");
        if (paramvalues != null && (paramvalues[0].equalsIgnoreCase("URL") || paramvalues[0].equalsIgnoreCase("URI"))) {
            key.setURI(item.getDecodedValue());
        } else {
            paramvalues = item.getParameter("ENCODING");
            if (paramvalues != null && (paramvalues[0].equalsIgnoreCase("B") || paramvalues[0].equalsIgnoreCase("BASE64"))) {
                key.setData(EncodingUtility.decodeBase64(EncodingUtility.removeWhiteSpace(item.getValue().getBytes())));
            }
            if ((paramvalues = item.getParameter("TYPE")) == null) {
                paramvalues = item.getParameter("DEFAULT");
            }
            if (paramvalues != null) {
                key.setContentType(paramvalues[0].toLowerCase());
            }
        }
        ct.setPublicKey(key);
    }

    public versitItem[] createItems(Contact ct) {
        if (!ct.hasPublicKey()) {
            return new versitItem[0];
        }
        versitItem[] items = new versitItem[1];
        Key key = ct.getPublicKey();
        if (key == null) {
            return new versitItem[0];
        }
        versitItem item = new versitItem("KEY");
        if (key.isURI()) {
            item.addParameter("VALUE", "URI");
            item.setValue(key.getURI());
        } else {
            String ctype = key.getContentType();
            ctype = ctype.substring(ctype.indexOf("/") + 1, ctype.length()).toUpperCase();
            item.addParameter("ENCODING", "B");
            item.addParameter("TYPE", ctype);
            item.setValue(new String(EncodingUtility.removeWhiteSpace(EncodingUtility.encodeBase64(key.getData()))));
        }
        items[0] = item;
        return items;
    }
}

