/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Image;
import net.wimpi.pim.contact.model.Organization;
import net.wimpi.pim.contact.model.OrganizationalIdentity;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.versitio.versitItem;

class LOGOItemHandler
implements ItemHandler {
    LOGOItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        Organization org;
        Image logo = Pim.getContactModelFactory().createImage();
        String[] paramvalues = null;
        paramvalues = item.getParameter("VALUE");
        if (paramvalues != null && (paramvalues[0].equalsIgnoreCase("URL") || paramvalues[0].equalsIgnoreCase("URI"))) {
            logo.setURI(item.getDecodedValue());
        } else {
            paramvalues = item.getParameter("ENCODING");
            if (paramvalues != null && (paramvalues[0].equalsIgnoreCase("B") || paramvalues[0].equalsIgnoreCase("BASE64"))) {
                logo.setData(EncodingUtility.decodeBase64(EncodingUtility.removeWhiteSpace(item.getValue().getBytes())));
            }
            if ((paramvalues = item.getParameter("TYPE")) == null) {
                paramvalues = item.getParameter("DEFAULT");
            }
            if (paramvalues != null) {
                logo.setContentType("image/" + paramvalues[0].toLowerCase());
            }
        }
        OrganizationalIdentity orgid = ct.getOrganizationalIdentity();
        if (orgid == null) {
            orgid = Pim.getContactModelFactory().createOrganizationalIdentity();
            ct.setOrganizationalIdentity(orgid);
        }
        if ((org = orgid.getOrganization()) == null) {
            org = Pim.getContactModelFactory().createOrganization();
            orgid.setOrganization(org);
        }
        org.setLogo(logo);
    }

    public versitItem[] createItems(Contact ct) {
        if (!ct.hasOrganizationalIdentity()) {
            return new versitItem[0];
        }
        if (!ct.getOrganizationalIdentity().hasOrganization()) {
            return new versitItem[0];
        }
        if (!ct.getOrganizationalIdentity().getOrganization().hasLogo()) {
            return new versitItem[0];
        }
        Image logo = ct.getOrganizationalIdentity().getOrganization().getLogo();
        versitItem[] items = new versitItem[1];
        versitItem item = new versitItem("LOGO");
        if (logo.isURI()) {
            item.addParameter("VALUE", "URI");
            item.setValue(logo.getURI());
        } else {
            String ctype = logo.getContentType();
            ctype = ctype.substring(ctype.indexOf("/") + 1, ctype.length()).toUpperCase();
            item.addParameter("ENCODING", "B");
            item.addParameter("TYPE", ctype);
            item.setValue(new String(EncodingUtility.removeWhiteSpace(EncodingUtility.encodeBase64(logo.getData()))));
        }
        items[0] = item;
        return items;
    }
}

