/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.ContactMarshaller;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.io.vcard.ItemHandlerManager;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.util.versitio.versitItem;
import net.wimpi.pim.util.versitio.versitToken;
import net.wimpi.pim.util.versitio.versitWriter;

public class vCardMarshaller
implements ContactMarshaller {
    private String m_Encoding = null;
    private versitItem m_ENDITEM = new versitItem("END", "VCARD");
    private versitItem m_STARTITEM = new versitItem("BEGIN", "VCARD");
    private versitItem m_V3ITEM = new versitItem("VERSION", "3.0");
    private versitItem m_PRODIDITEM = new versitItem("PRODID", "jpim.sourceforge.net");
    private ItemHandlerManager m_ItemHandlerManager = ItemHandlerManager.getReference();

    public vCardMarshaller() {
    }

    public vCardMarshaller(String enc) {
        this.m_Encoding = enc;
    }

    public String getEncoding() {
        return this.m_Encoding;
    }

    public void setEncoding(String encoding) {
        this.m_Encoding = encoding;
    }

    public void marshallContact(OutputStream out, Contact contact) {
        Contact[] contacts = new Contact[]{contact};
        this.marshallContacts(out, contacts);
    }

    public void marshallContacts(OutputStream out, Contact[] contacts) {
        try {
            for (int i = 0; i < contacts.length; ++i) {
                this.marshallCard(out, contacts[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void marshallCard(OutputStream out, Contact contact) {
        ArrayList<versitItem> list = new ArrayList<versitItem>(20);
        list.add(this.m_STARTITEM);
        list.add(this.m_V3ITEM);
        for (int i = 0; i < versitToken.VCARD_ITEM_LIST.length; ++i) {
            this.addItem(list, versitToken.VCARD_ITEM_LIST[i], contact);
        }
        String[] xtnd = this.m_ItemHandlerManager.listExtensions();
        for (int i = 0; i < xtnd.length; ++i) {
            this.addItem(list, xtnd[i], contact);
        }
        if (Pim.isAnnounced()) {
            list.add(this.m_PRODIDITEM);
        }
        list.add(this.m_ENDITEM);
        try {
            versitWriter writer = null;
            writer = this.m_Encoding != null ? new versitWriter(out, this.m_Encoding) : new versitWriter(out);
            writer.writeCard(list);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addItem(List list, String str, Contact ct) {
        ItemHandler handler = this.m_ItemHandlerManager.getItemHandler(str);
        if (handler != null) {
            versitItem[] items = handler.createItems(ct);
            for (int i = 0; i < items.length; ++i) {
                list.add(items[i]);
            }
        }
    }
}

