/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.ListIterator;
import net.wimpi.pim.contact.basicimpl.ContactImpl;
import net.wimpi.pim.contact.io.ContactUnmarshaller;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.io.vcard.ItemHandlerManager;
import net.wimpi.pim.contact.io.vcard.vCardMarshaller;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.util.versitio.versitException;
import net.wimpi.pim.util.versitio.versitItem;
import net.wimpi.pim.util.versitio.versitParser;

public class vCardUnmarshaller
implements ContactUnmarshaller {
    private String m_Encoding = null;
    private ItemHandlerManager m_ItemHandlerManager = ItemHandlerManager.getReference();
    private boolean m_Strict = true;

    public vCardUnmarshaller() {
    }

    public vCardUnmarshaller(String enc) {
        this.m_Encoding = enc;
    }

    public String getEncoding() {
        return this.m_Encoding;
    }

    public void setEncoding(String encoding) {
        this.m_Encoding = encoding;
    }

    public Contact unmarshallContact(InputStream in) {
        return this.unmarshallContacts(in)[0];
    }

    public Contact[] unmarshallContacts(InputStream in) {
        Contact[] contacts = null;
        try {
            List cards = this.parseStream(in);
            contacts = new Contact[cards.size()];
            int i = 0;
            for (List card : cards) {
                contacts[i] = this.processCard(card);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return contacts;
    }

    public void setStrict(boolean b) {
        this.m_Strict = b;
    }

    public boolean isStrict() {
        return this.m_Strict;
    }

    private List parseStream(InputStream in) throws versitException {
        versitParser parser = null;
        if (this.m_Encoding == null) {
            parser = new versitParser(in);
        } else {
            try {
                parser = new versitParser(in, this.m_Encoding);
                parser.setValidating(this.m_Strict);
            }
            catch (UnsupportedEncodingException ex) {
                throw new versitException("Encoding " + this.m_Encoding + "not supported.");
            }
        }
        parser.parse();
        return parser.getCardObjects();
    }

    private Contact processCard(List items) {
        ContactImpl ct = new ContactImpl();
        if (items != null) {
            ListIterator iter = items.listIterator();
            while (iter.hasNext()) {
                versitItem item = (versitItem)iter.next();
                this.processItem(ct, item);
            }
        }
        return ct;
    }

    private void processItem(Contact ct, versitItem item) {
        ItemHandler handler = this.m_ItemHandlerManager.getItemHandler(item.getIdentifier());
        if (handler != null) {
            handler.handleItem(ct, item);
        }
    }

    public static void main(String[] args) {
        try {
            File infile = new File(args[0]);
            FileInputStream fin = new FileInputStream(infile);
            vCardUnmarshaller unmarshall = new vCardUnmarshaller();
            Contact testct = unmarshall.unmarshallContact(fin);
            vCardMarshaller marshall = new vCardMarshaller();
            marshall.marshallContact(System.out, testct);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

