/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.wimpi.pim.util.Base64;
import net.wimpi.pim.util.QuotedPrintable;

public class EncodingUtility {
    private static final byte[] NEWLINE_ENC = new byte[]{92, 110};

    public static byte[] decodeBase64(byte[] data) {
        return Base64.decode(data);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.decode(data.getBytes());
    }

    public static byte[] encodeBase64(byte[] data) {
        return Base64.encode(data);
    }

    public static String decodeQP(String data) {
        return QuotedPrintable.decode(data);
    }

    public static String encodeQP(String data) {
        return QuotedPrintable.encode(data);
    }

    public static byte[] removeWhiteSpace(byte[] data) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(data.length);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 10 || data[i] == 13 || data[i] == 9 || data[i] == 32) continue;
            bout.write(data[i]);
        }
        return bout.toByteArray();
    }

    public static InputStream removeWhiteSpace(InputStream data) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(data.available());
        int in = 0;
        while (in != -1) {
            in = data.read();
            if (in == -1 || in == 10 || in == 13 || in == 9 || in == 32) continue;
            bout.write(in);
        }
        return new ByteArrayInputStream(bout.toByteArray());
    }

    public static byte[] encodeLineBreaks(byte[] data) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(data.length);
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == 13 && data[i + 1] == 10) {
                    bout.write(NEWLINE_ENC);
                    ++i;
                    continue;
                }
                if (data[i] == 13) {
                    bout.write(NEWLINE_ENC);
                    continue;
                }
                if (data[i] == 10) {
                    bout.write(NEWLINE_ENC);
                    continue;
                }
                bout.write(data[i]);
            }
            return bout.toByteArray();
        }
        catch (Exception ex) {
            return data;
        }
    }

    public static String encodeLineBreaks(String str) {
        return new String(EncodingUtility.encodeLineBreaks(str.getBytes()));
    }

    public static InputStream encodeLineBreaks(InputStream data) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(data.available());
        int in = 0;
        while (in != -1) {
            in = data.read();
            if (in == -1) continue;
            if (in == 13) {
                in = data.read();
                if (in == 10) {
                    bout.write(NEWLINE_ENC);
                    continue;
                }
                bout.write(NEWLINE_ENC);
                bout.write(in);
                continue;
            }
            if (in == 10) {
                bout.write(NEWLINE_ENC);
                continue;
            }
            bout.write(in);
        }
        return new ByteArrayInputStream(bout.toByteArray());
    }
}

