/*
 * Decompiled with CFR 0.152.
 */
package net.windwards.mavendbusplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.freedesktop.dbus.bin.CreateInterface;
import org.freedesktop.dbus.exceptions.DBusException;
import org.xml.sax.SAXException;

public class DBusXMLMojo
extends AbstractMojo {
    private MavenProject project;
    private File interfaces;
    private File output;
    protected FilenameFilter xmlFiles = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            boolean accept = name.toLowerCase().endsWith(".xml");
            if (accept) {
                return true;
            }
            DBusXMLMojo.this.getLog().warn((CharSequence)("Ignoring non-xml file " + name));
            return false;
        }
    };

    public void execute() throws MojoExecutionException {
        String path = this.output.getPath();
        this.project.addCompileSourceRoot(path);
        for (File iface : this.interfaces.listFiles(this.xmlFiles)) {
            FileStreamFactory factory = new FileStreamFactory(path);
            CreateInterface createInterface = new CreateInterface((CreateInterface.PrintStreamFactory)factory, false);
            FileReader input = null;
            try {
                input = new FileReader(iface);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not read interface XML from " + iface.getPath(), (Exception)e);
            }
            try {
                createInterface.createInterface((Reader)input);
            }
            catch (ParserConfigurationException e) {
                throw new MojoExecutionException("dbus-java internal error on XML parser", (Exception)e);
            }
            catch (SAXException e) {
                throw new MojoExecutionException("Malformatted interface XML", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write java source", (Exception)e);
            }
            catch (DBusException e) {
                throw new MojoExecutionException("DBus error", (Exception)((Object)e));
            }
        }
    }

    public static class FileStreamFactory
    extends CreateInterface.PrintStreamFactory {
        File targetdir;

        public FileStreamFactory(String targetdir) {
            this.targetdir = new File(targetdir);
        }

        public void init(String file, String path) {
            new File(this.targetdir, path).mkdirs();
        }

        public PrintStream createPrintStream(String file) throws IOException {
            File output = new File(this.targetdir, file);
            return new PrintStream(new FileOutputStream(output));
        }
    }
}

