/*
 * Decompiled with CFR 0.152.
 */
package net.wombyte;

public class Wombyte {
    private static boolean isValueAllowed(byte character) {
        return 32 <= character && character <= 126;
    }

    private static String filterValue(String value) {
        StringBuilder builder = new StringBuilder();
        for (byte ch : value.getBytes()) {
            if (!Wombyte.isValueAllowed(ch)) continue;
            builder.append((char)ch);
        }
        return builder.toString();
    }

    private static String stripValue(String value) {
        return value.length() > 256 ? value.substring(0, 256) : value;
    }

    public static String toValue(String value) {
        return Wombyte.stripValue(Wombyte.filterValue(value));
    }

    private static boolean isKeyAllowed(byte character) {
        return Character.isLetterOrDigit(character) || character == 95;
    }

    private static String filterField(String value) {
        StringBuilder builder = new StringBuilder();
        for (byte ch : value.getBytes()) {
            if (!Wombyte.isKeyAllowed(ch)) continue;
            builder.append((char)ch);
        }
        return builder.toString();
    }

    private static String stripField(String value) {
        return value.length() > 64 ? value.substring(0, 64) : value;
    }

    public static String toField(String value) {
        return Wombyte.stripField(Wombyte.filterField(value.replace(' ', '_').replace('-', '_'))).toLowerCase();
    }
}

