/*
 * Decompiled with CFR 0.152.
 */
package net.wombyte.buffer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.wombyte.WombyteHttpClient;
import net.wombyte.buffer.WombyteBufferWriter;
import net.wombyte.event.WombyteEventContext;
import net.wombyte.tracker.WombyteTelemetry;

public class WombyteBuffer
implements Closeable {
    private final ReadWriteLock writeLock = new ReentrantReadWriteLock();
    private final ReadWriteLock sendLock = new ReentrantReadWriteLock();
    private final File directory;
    private final WombyteHttpClient client;
    private final WombyteTelemetry telemetry;
    private WombyteBufferWriter writer;

    public WombyteBuffer(File directory, WombyteHttpClient client, WombyteTelemetry telemetry) {
        this.directory = directory;
        this.client = client;
        this.telemetry = telemetry;
        this.writer = this.createWriter();
    }

    private WombyteBufferWriter createWriter() {
        UUID uuid = UUID.randomUUID();
        return new WombyteBufferWriter(this.directory.toString() + "/" + uuid);
    }

    private File[] rotate() {
        File[] files = this.directory.listFiles();
        this.writeLock.writeLock().lock();
        try {
            this.writer.close();
            this.writer = this.createWriter();
        }
        finally {
            this.writeLock.writeLock().unlock();
        }
        return files;
    }

    public CompletableFuture<Boolean> append(WombyteEventContext context, Map<String, Object> attributes) {
        Object[] record = new Object[]{context.timestamp, context.id, context.event, context.app, attributes};
        return CompletableFuture.supplyAsync(() -> {
            this.writeLock.writeLock().lock();
            try {
                this.writer.write(record);
            }
            finally {
                this.writeLock.writeLock().unlock();
            }
            return true;
        });
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public void flushLines() {
        this.sendLock.writeLock().lock();
        try {
            for (File file : this.rotate()) {
                Instant start = Instant.now();
                int response = this.client.sendFile(file);
                if (response < 500) {
                    BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    this.telemetry.logBatchTimeRange(attr.creationTime().toInstant(), attr.lastModifiedTime().toInstant());
                    this.telemetry.logBatchSize(Files.size(file.toPath()));
                    this.telemetry.logServerResponse(Instant.now(), response, Duration.between(start, Instant.now()).toMillis());
                    Files.delete(file.toPath());
                    continue;
                }
                this.telemetry.logServerResponse(Instant.now(), response, Duration.between(start, Instant.now()).toMillis());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.sendLock.writeLock().unlock();
        }
    }
}

