/*
 * Decompiled with CFR 0.152.
 */
package net.wombyte.buffer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class WombyteBufferWriter
implements Closeable {
    private static final ObjectMapper mapper = new ObjectMapper();
    private FileChannel channel;
    private final String file;

    WombyteBufferWriter(String file) {
        this.file = file;
    }

    void write(Object[] records) {
        try {
            FileChannel lazyChanel = this.getWriter();
            lazyChanel.write(ByteBuffer.wrap(mapper.writeValueAsBytes((Object)records)));
            lazyChanel.write(ByteBuffer.wrap("\n".getBytes()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private FileChannel getWriter() throws IOException {
        if (this.channel == null) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
            this.channel = randomAccessFile.getChannel();
            this.channel.tryLock();
        }
        return this.channel;
    }

    static {
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    }
}

