/*
 * Decompiled with CFR 0.152.
 */
package net.wombyte.event;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.wombyte.Event;
import net.wombyte.Wombyte;
import net.wombyte.buffer.WombyteBuffer;
import net.wombyte.event.WombyteEventContext;

public class WombyteEvent
implements Event {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final WombyteEventContext context;
    private final WombyteBuffer buffer;

    public WombyteEvent(WombyteEventContext context, WombyteBuffer buffer) {
        this.context = context;
        this.buffer = buffer;
    }

    @Override
    public Event addStrings(Map<String, String> attrs) {
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            this.attributes.put(Wombyte.toField(entry.getKey()), Wombyte.toValue(entry.getValue()));
        }
        return this;
    }

    @Override
    public Event addString(String key, String value) {
        this.attributes.put(Wombyte.toField(key), Wombyte.toValue(value));
        return this;
    }

    @Override
    public Event addNumerals(Map<String, Double> attrs) {
        for (Map.Entry<String, Double> entry : attrs.entrySet()) {
            this.attributes.put(Wombyte.toField(entry.getKey()), entry.getValue());
        }
        return this;
    }

    @Override
    public Event addNumeral(String key, double value) {
        this.attributes.put(Wombyte.toField(key), value);
        return this;
    }

    @Override
    public CompletableFuture<Boolean> send() {
        int numerals = 0;
        int strings = 0;
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            if (entry.getValue() instanceof Double) {
                ++numerals;
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            ++strings;
        }
        return numerals <= 30 && strings <= 30 ? this.buffer.append(this.context, this.attributes) : CompletableFuture.completedFuture(false);
    }
}

