/*
 * Decompiled with CFR 0.152.
 */
package net.wombyte.tracker;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.wombyte.EventTracker;
import net.wombyte.WombyteHttpClient;
import net.wombyte.buffer.WombyteBuffer;
import net.wombyte.buffer.WombyteBufferArgs;
import net.wombyte.tracker.PathSetter;
import net.wombyte.tracker.RemoteSetter;
import net.wombyte.tracker.SilentWombyteTelemetry;
import net.wombyte.tracker.TrackerBuilder;
import net.wombyte.tracker.WombyteTelemetry;
import net.wombyte.tracker.WombyteTracker;

public final class WombyteTrackerBuilder
implements PathSetter,
RemoteSetter,
TrackerBuilder {
    private static final ConcurrentHashMap<WombyteBufferArgs, WombyteBuffer> buffers = new ConcurrentHashMap();
    private String directory;
    private String host;
    private String token;
    private String secret;
    private boolean secure;
    private int timeout;
    private WombyteTelemetry telemetry;

    public static PathSetter create() {
        return new WombyteTrackerBuilder();
    }

    private WombyteTrackerBuilder() {
    }

    @Override
    public RemoteSetter setLogDirectory(String path) {
        if (Objects.isNull(path)) {
            throw new IllegalArgumentException();
        }
        this.directory = path;
        return this;
    }

    @Override
    public TrackerBuilder setRemote(String host, String token, String secret) {
        return this.setRemote(host, token, secret, true, 0);
    }

    @Override
    public TrackerBuilder setRemote(String host, String token, String secret, boolean secure, int timeout) {
        if (Objects.isNull(host) || Objects.isNull(token) || Objects.isNull(secret)) {
            throw new IllegalArgumentException();
        }
        this.host = host;
        this.token = token;
        this.secret = secret;
        this.secure = secure;
        this.timeout = timeout;
        return this;
    }

    @Override
    public TrackerBuilder setTelemetry(WombyteTelemetry telemetry) {
        this.telemetry = telemetry;
        return this;
    }

    @Override
    public EventTracker build(String app) {
        WombyteBufferArgs args = new WombyteBufferArgs(this.directory, this.host, this.token, this.secret, this.secure, this.timeout);
        if (this.telemetry == null) {
            this.telemetry = new SilentWombyteTelemetry();
        }
        WombyteBuffer buffer = buffers.computeIfAbsent(args, bufferArgs -> WombyteTrackerBuilder.createBuffer(bufferArgs, this.telemetry));
        return new WombyteTracker(buffer, app);
    }

    private static WombyteBuffer createBuffer(WombyteBufferArgs args, WombyteTelemetry telemetry) {
        try {
            File directory = new File(args.directory + "/" + args.host);
            Files.createDirectories(directory.toPath(), new FileAttribute[0]);
            return new WombyteBuffer(directory, new WombyteHttpClient(args.host, args.token, args.secret, args.secure, args.timeout), telemetry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

