/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.maven;

import java.util.HashSet;
import java.util.List;
import net.wouterdanes.docker.maven.AbstractPreVerifyDockerMojo;
import net.wouterdanes.docker.provider.model.ImageBuildConfiguration;
import net.wouterdanes.docker.remoteapi.exception.DockerException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build-images", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, instantiationStrategy=InstantiationStrategy.PER_LOOKUP)
public class BuildImageMojo
extends AbstractPreVerifyDockerMojo {
    @Parameter(required=true)
    private List<ImageBuildConfiguration> images;

    public void setImages(List<ImageBuildConfiguration> images) {
        this.images = images;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.images == null || this.images.isEmpty()) {
            this.getLog().warn((CharSequence)"No images to build specified.");
            return;
        }
        this.validateAllImages();
        for (ImageBuildConfiguration image : this.images) {
            try {
                this.logImageConfig(image);
                String imageId = this.getDockerProvider().buildImage(image);
                this.getLog().info((CharSequence)String.format("Image '%s' has Id '%s'", image.getId(), imageId));
                this.registerBuiltImage(imageId, image);
            }
            catch (DockerException e) {
                String errorMessage = String.format("Cannot build image '%s'", image.getId());
                this.handleDockerException(errorMessage, e);
            }
        }
    }

    private void logImageConfig(ImageBuildConfiguration image) {
        StringBuilder builder = new StringBuilder(String.format("Building image '%s'", image.getId()));
        if (image.getNameAndTag() != null) {
            builder.append(String.format(", with name and tag '%s'", image.getNameAndTag()));
        }
        builder.append("..");
        this.getLog().info((CharSequence)builder.toString());
    }

    private void validateAllImages() throws MojoExecutionException {
        HashSet<String> ids = new HashSet<String>(this.images.size());
        for (ImageBuildConfiguration image : this.images) {
            if (ids.contains(image.getId())) {
                throw new MojoExecutionException(String.format("Image ID '%s' used twice, Image IDs must be unique!", image.getId()));
            }
            ids.add(image.getId());
        }
    }

    @Override
    protected String getMojoGoalName() {
        return "build-images";
    }
}

