/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.maven;

import net.wouterdanes.docker.maven.AbstractPreVerifyDockerMojo;
import net.wouterdanes.docker.provider.model.BuiltImageInfo;
import net.wouterdanes.docker.remoteapi.exception.DockerException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="stop-containers", threadSafe=true, defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class StopContainerMojo
extends AbstractPreVerifyDockerMojo {
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.cleanUpStartedContainers();
        for (BuiltImageInfo image : this.getBuiltImages()) {
            if (image.shouldKeepAfterStopping()) {
                this.getLog().info((CharSequence)String.format("Keeping image %s", image.getImageId()));
                continue;
            }
            this.getLog().info((CharSequence)String.format("Removing image '%s' (%s) ...", image.getImageId(), image.getStartId()));
            try {
                this.getDockerProvider().removeImage(image.getImageId());
            }
            catch (DockerException e) {
                this.getLog().error((CharSequence)"Failed to remove image", (Throwable)e);
            }
        }
    }

    @Override
    protected String getMojoGoalName() {
        return "stop-containers";
    }
}

