/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.provider.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.wouterdanes.docker.remoteapi.model.ContainerLink;

public class ContainerStartConfiguration {
    public static final int DEFAULT_STARTUP_TIMEOUT = 300;
    private String image;
    private String id;
    private List<ContainerLink> links;
    private Map<String, String> env;
    private String waitForStartup;
    private int startupTimeout;
    private String hostname;
    private String macAddress;

    public ContainerStartConfiguration fromImage(String image) {
        this.image = image;
        return this;
    }

    public ContainerStartConfiguration withId(String id) {
        this.id = id;
        return this;
    }

    public ContainerStartConfiguration withLinks(ContainerLink ... links) {
        if (this.links == null) {
            this.links = new ArrayList<ContainerLink>(links.length);
        }
        Collections.addAll(this.links, links);
        return this;
    }

    public ContainerStartConfiguration withLink(ContainerLink link) {
        return this.withLinks(link);
    }

    public ContainerStartConfiguration waitForStartup(String pattern) {
        this.waitForStartup = pattern;
        return this;
    }

    public ContainerStartConfiguration withStartupTimeout(int timeout) {
        this.startupTimeout = timeout;
        return this;
    }

    public ContainerStartConfiguration withEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public ContainerStartConfiguration withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public ContainerStartConfiguration withMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    public String getImage() {
        return this.image;
    }

    public String getId() {
        return this.id != null ? this.id : this.image;
    }

    public List<ContainerLink> getLinks() {
        return this.links != null ? Collections.unmodifiableList(this.links) : Collections.emptyList();
    }

    public Map<String, String> getEnv() {
        return this.env != null ? Collections.unmodifiableMap(this.env) : Collections.emptyMap();
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getWaitForStartup() {
        return this.waitForStartup;
    }

    public int getStartupTimeout() {
        return this.startupTimeout != 0 ? this.startupTimeout : 300;
    }
}

