/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.provider.model;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class PushableImage {
    private final String imageId;
    private final Optional<String> nameAndTag;

    public PushableImage(String imageId, Optional<String> nameAndTag) {
        Validate.notBlank((CharSequence)imageId, (String)"Image id was null or empty", (Object[])new Object[0]);
        Validate.notNull((Object)nameAndTag.orElse(""), (String)"Name and tag was null or empty", (Object[])new Object[0]);
        this.imageId = imageId;
        this.nameAndTag = nameAndTag;
    }

    public String getImageId() {
        return this.imageId;
    }

    public Optional<String> getNameAndTag() {
        return this.nameAndTag;
    }

    public int hashCode() {
        return Objects.hash(this.imageId, this.nameAndTag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PushableImage)) {
            return false;
        }
        PushableImage other = (PushableImage)obj;
        return this.imageId.equals(other.getImageId()) && this.nameAndTag.equals(other.getNameAndTag());
    }

    public String toString() {
        return "PushableImage[imageId=" + this.imageId + ", nameAndTag=" + this.nameAndTag.orElse("<Unspecified>") + "]";
    }
}

